/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.toJava.Emitter;
import org.globus.ogsa.tools.wsdl.toJava.JavaGridClassWriter;

public class JavaDelegationWriter
extends JavaGridClassWriter {
    private String m_implClassName = null;
    private boolean m_isPersistent = false;

    public JavaDelegationWriter(Emitter emitter, String fullClassName, String implClassName, String type, Service service, boolean isPersistent) throws Exception {
        super(emitter, fullClassName, type, service);
        this.m_isPersistent = isPersistent;
        this.m_implClassName = implClassName;
        this.m_myImports = new Vector();
        this.m_myImplements = new Vector();
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        pw.println("    public static QName[] operations = new QName[] {");
        this.writeOperationArray(pw);
        pw.println("    };");
        if (this.m_isPersistent) {
            pw.println("    private PersistentGridServiceBase base;");
        } else {
            pw.println("    private GridServiceBase base;");
        }
        pw.println("    private " + this.m_implClassName + " impl;");
        pw.println("    static Log logger = LogFactory.getLog(" + this.getClassName() + ".class.getName());");
        pw.println();
        pw.println("    public " + this.getClassName() + "() throws java.rmi.RemoteException {");
        pw.println("       try {");
        pw.println("          this.impl = new " + this.m_implClassName + "();");
        pw.println("       }");
        pw.println("       catch (Exception e) {");
        pw.println("          throw new java.rmi.RemoteException(e.getMessage());");
        pw.println("       }");
        pw.println("    }");
        pw.println();
        pw.println("    public " + this.getClassName() + "(" + this.m_implClassName + " impl) {");
        pw.println("       this.impl = impl;");
        pw.println("    }");
        pw.println();
        pw.println("    public QName[] getOperations() {");
        pw.println("        return operations;");
        pw.println("    }");
        pw.println();
        pw.println("    public void initialize(GridServiceBase base) throws GridServiceException {");
        if (this.m_isPersistent) {
            pw.println("        this.base = (PersistentGridServiceBase)base;");
        } else {
            pw.println("        this.base = base;");
        }
        pw.println("    }");
        pw.println();
        if (this.m_isPersistent) {
            pw.println("    public void postPersistentCreate(GridContext context) throws GridServiceException {");
            pw.println("    }");
            pw.println();
        }
        pw.println("    public void preCreate(GridServiceBase base) throws GridServiceException {");
        pw.println("    }");
        pw.println();
        pw.println("    public void postCreate(GridContext context) throws GridServiceException {");
        pw.println("        ServiceDataAnnotation.setupServiceData(this, this.base.getServiceDataSet());");
        pw.println("    }");
        pw.println();
        pw.println("    public void activate(GridContext context) throws GridServiceException {");
        pw.println("    }");
        pw.println();
        pw.println("    public void deactivate(GridContext context) throws GridServiceException {");
        pw.println("    }");
        pw.println();
        pw.println("    public void preDestroy(GridContext context) throws GridServiceException {");
        pw.println("    }");
        pw.println();
        this.writeOperations(pw);
    }

    protected String getImplementsText() {
        String ret = "implements OperationProvider";
        ret = this.m_isPersistent ? ret + ", PersistentGridServiceCallback" : ret + ", GridServiceCallback";
        return ret;
    }

    protected void writeOperationArray(PrintWriter pw) throws IOException {
        Iterator i = this.m_service.getPorts().values().iterator();
        while (i.hasNext()) {
            Port port = (Port)i.next();
            Binding binding = port.getBinding();
            PortType curPortType = binding.getPortType();
            String namespace = curPortType.getQName().getNamespaceURI();
            List operations = binding.getBindingOperations();
            int j = 0;
            while (j < operations.size()) {
                BindingOperation bindingOperation = (BindingOperation)operations.get(j);
                Operation operation = bindingOperation.getOperation();
                if (JavaGridClassWriter.isUserOperation(operation, namespace) || operation.getName().equals("deliverNotification")) {
                    pw.println("        new QName(\"" + namespace + "\"" + ", \"" + operation.getName() + "\"),");
                }
                ++j;
            }
        }
    }

    protected void writeOperations(PrintWriter pw) throws IOException {
        Iterator i = this.m_service.getPorts().values().iterator();
        while (i.hasNext()) {
            Port port = (Port)i.next();
            Binding binding = port.getBinding();
            PortType curPortType = binding.getPortType();
            this.writeUserPortTypeOperations(pw, binding, curPortType.getQName().getNamespaceURI());
        }
    }

    protected void writeUserPortTypeOperations(PrintWriter pw, Binding binding, String namespaceURI) {
        List operations = binding.getBindingOperations();
        int i = 0;
        while (i < operations.size()) {
            BindingOperation bindingOperation = (BindingOperation)operations.get(i);
            Operation operation = bindingOperation.getOperation();
            if (JavaGridClassWriter.isUserOperation(operation, namespaceURI) || operation.getName().equals("deliverNotification")) {
                BindingEntry bindingEntry = this.m_symbolTable.getBindingEntry(binding.getQName());
                this.writeComment(pw, operation.getDocumentationElement());
                Parameters parms = bindingEntry.getParameters(operation);
                pw.println(parms.signature + " {");
                if (!operation.getName().equals("deliverNotification")) {
                    pw.print("       ");
                    if (parms.outputs > 0) {
                        pw.print("return ");
                    }
                    pw.print("this.impl." + operation.getName() + "(");
                    int j = 0;
                    while (j < parms.list.size()) {
                        Parameter parm = (Parameter)parms.list.elementAt(j);
                        if (j < parms.list.size() - 1) {
                            pw.print(parm.getName() + ", ");
                        } else {
                            pw.print(parm.getName());
                        }
                        ++j;
                    }
                    pw.print(");");
                    pw.println();
                }
                pw.println("    }");
                pw.println();
            }
            ++i;
        }
    }
}

