/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl.toJava;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;
import org.globus.ogsa.tools.utils.ResourceBundleUtil;
import org.globus.ogsa.tools.wsdl.toJava.JavaGridClassWriter;

public class JavaDirectImplWriter
extends JavaClassWriter {
    private Service m_service = null;

    public JavaDirectImplWriter(Emitter emitter, String fullClassName, String type, Service service) throws Exception {
        super(emitter, fullClassName, type);
        this.m_service = service;
    }

    protected void writeHeaderComments(PrintWriter pw) throws IOException {
        String localFile = this.getFileName();
        int lastSepChar = localFile.lastIndexOf(File.separatorChar);
        if (lastSepChar >= 0) {
            localFile = localFile.substring(lastSepChar + 1);
        }
        pw.println("/**");
        pw.println(" * " + localFile);
        pw.println(" *");
        pw.println(" * " + ResourceBundleUtil.getMessage("AutoGenNotice"));
        pw.println(" *  " + ResourceBundleUtil.getMessage("OGSALongName"));
        pw.println(" *");
        pw.println(" */");
        pw.println();
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        pw.println("    public " + this.getClassName() + "() {");
        pw.println("    }");
        pw.println();
        Iterator i = this.m_service.getPorts().values().iterator();
        while (i.hasNext()) {
            Port port = (Port)i.next();
            Binding binding = port.getBinding();
            PortType pt = binding.getPortType();
            String namespaceURI = pt.getQName().getNamespaceURI();
            List operations = binding.getBindingOperations();
            int j = 0;
            while (j < operations.size()) {
                BindingOperation operation = (BindingOperation)operations.get(j);
                Operation ptOperation = operation.getOperation();
                if (JavaGridClassWriter.isUserOperation(ptOperation, namespaceURI)) {
                    OperationType type = ptOperation.getStyle();
                    BindingEntry bEntry = this.emitter.getSymbolTable().getBindingEntry(binding.getQName());
                    Parameters parameters = bEntry.getParameters(operation.getOperation());
                    if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                        pw.println(parameters.signature);
                        pw.println();
                    } else {
                        String signature = parameters.signature.substring(0, parameters.signature.lastIndexOf(")") + 1) + " {";
                        pw.println(signature);
                        if (parameters.returnParam != null) {
                            TypeEntry returnType = parameters.returnParam.getType();
                            pw.print("        return ");
                            if (Utils.isPrimitiveType((TypeEntry)returnType)) {
                                String returnString = returnType.getName();
                                if ("boolean".equals(returnString)) {
                                    pw.println("false;");
                                } else if ("byte".equals(returnString)) {
                                    pw.println("(byte)-3;");
                                } else if ("short".equals(returnString)) {
                                    pw.println("(short)-3;");
                                } else {
                                    pw.println("-3;");
                                }
                            } else {
                                pw.println("null;");
                            }
                        }
                        pw.println("    }");
                        pw.println();
                    }
                }
                ++j;
            }
        }
    }
}

