/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.axis.wsdl.fromJava.Emitter;
import org.apache.axis.wsdl.gen.GeneratorFactory;
import org.globus.ogsa.tools.wsdl.JavaGridGeneratorFactory;

public class EJBServiceBuilder {
    private File dir;
    private File generatedDir;
    private String reversePackage;
    private String packageName;
    private String servicePathName;
    private String serviceName;
    private String containerType;
    private String jndiName;
    private boolean isSecure;
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    public EJBServiceBuilder(String dirName, String homeClassName, String remoteClassName, String _servicePathName, String _containerType, boolean _isSecure) {
        int pos;
        this.dir = new File(dirName);
        this.generatedDir = new File(dirName, "generated");
        this.servicePathName = _servicePathName;
        this.containerType = _containerType;
        this.isSecure = _isSecure;
        if (this.servicePathName == null) {
            this.servicePathName = remoteClassName.replace('.', '/');
        }
        this.serviceName = (pos = this.servicePathName.lastIndexOf("/")) != -1 ? this.servicePathName.substring(pos + 1) : this.servicePathName;
        if (this.containerType.equals("jboss")) {
            this.jndiName = this.serviceName;
        } else if (this.containerType.equals("websphere")) {
            this.jndiName = homeClassName.replace('.', '/');
        }
        String name = remoteClassName;
        this.reversePackage = "";
        pos = name.lastIndexOf(46);
        name = this.packageName = name.substring(0, pos);
        pos = name.lastIndexOf(46, pos - 1);
        while (pos > 0) {
            if (this.reversePackage.length() > 0) {
                this.reversePackage = this.reversePackage + ".";
            }
            this.reversePackage = this.reversePackage + name.substring(pos + 1);
            name = name.substring(0, pos);
            pos = name.lastIndexOf(46);
        }
        if (this.reversePackage.length() > 0) {
            this.reversePackage = this.reversePackage + ".";
        }
        this.reversePackage = this.reversePackage + name;
    }

    public void buildService(Class homeInterface, Class remoteInterface, String serviceUrl, boolean exposeHome) {
        try {
            if (exposeHome) {
                System.out.println("generating home interface WSDL and stubs");
                String homeSkelName = this.packageName + "." + this.serviceName + "HomeServiceProvider";
                Class<?> homeSkel = Class.forName(homeSkelName);
                this.writeWsdl(homeSkel, this.serviceName, serviceUrl, true);
                this.writeStubs(true);
            }
            System.out.println("generating wsdl with Java2WSDL");
            this.writeWsdl(remoteInterface, this.serviceName, serviceUrl, false);
            System.out.println("generating stubs with WSDL2Java");
            this.writeStubs(false);
            System.out.println("generating ejb service skeleton");
            this.writeSkeleton(remoteInterface, false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("EJB Service Builder is done");
    }

    private void writeWsdl(Class cl, String serviceName, String serviceUrl, boolean isHome) throws Exception {
        if (isHome) {
            serviceName = serviceName + "Home";
        }
        Emitter wsdlEmitter = new Emitter();
        wsdlEmitter.setLocationUrl(serviceUrl + (isHome ? "/Home" : "/Remote"));
        wsdlEmitter.setIntfNamespace("http://" + this.reversePackage + "/");
        wsdlEmitter.setStopClasses(isHome ? "org.globus.ogsa.impl.core.factory.EJBHomeFactoryProvider" : "javax.ejb.EJBObject");
        wsdlEmitter.setPortTypeName(serviceName + "PortType");
        wsdlEmitter.setServiceElementName(serviceName + "Service");
        wsdlEmitter.setCls(cl);
        wsdlEmitter.emit(new File(this.dir, serviceName + ".wsdl").getAbsolutePath(), 0);
    }

    private void writeStubs(boolean isHome) throws Exception {
        org.apache.axis.wsdl.toJava.Emitter javaEmitter = new org.apache.axis.wsdl.toJava.Emitter();
        javaEmitter.setFactory((GeneratorFactory)new JavaGridGeneratorFactory(javaEmitter));
        javaEmitter.setOutputDir(this.generatedDir.getAbsolutePath());
        File wsdlFile = new File(this.dir, this.serviceName + ".wsdl");
        if (isHome) {
            wsdlFile = new File(this.dir, this.serviceName + "Home.wsdl");
        }
        javaEmitter.run(wsdlFile.getAbsolutePath());
    }

    private void checkServerConfig(String fileName, boolean exposeHome) throws IOException {
        String factoryName = this.servicePathName + (exposeHome ? "Home" : "") + "FactoryService";
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(byteOut);
        String line = in.readLine();
        while (line != null) {
            if (line.indexOf(factoryName) != -1) {
                System.out.println(fileName + " already contains " + factoryName);
                break;
            }
            if (line.indexOf("</deployment>") != -1) {
                out.println();
                out.println(" <service name=\"" + factoryName + "\" provider=\"Handler\" style=\"wrapped\">");
                out.println("  <parameter name=\"allowedMethods\" value=\"*\"/>");
                out.println("  <parameter name=\"persistent\" value=\"true\"/>");
                out.println("  <parameter name=\"className\" value=\"org.gridforum.ogsi.NotificationFactory\"/>");
                out.println("  <parameter name=\"baseClassName\" value=\"org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl\"/>");
                out.println("  <parameter name=\"factoryCallback\" value=\"org.globus.ogsa.impl.core.factory.EJBFactoryCallback\"/>");
                out.println("  <parameter name=\"schemaPath\" value=\"schema/ogsi/ogsi_notification_factory_service.wsdl\"/>");
                out.println("  <parameter name=\"operationProviders\" value=\"org.globus.ogsa.impl.ogsi.FactoryProvider\"/>");
                out.println("  <parameter name=\"handlerClass\" value=\"org.globus.ogsa.handlers.RPCURIProvider\"/>");
                if (this.containerType.equals("jboss")) {
                    out.println("  <parameter name=\"java.naming.factory.initial\" value=\"org.jnp.interfaces.NamingContextFactory\"/>");
                    out.println("  <parameter name=\"java.naming.provider.url\" value=\"localhost:1099\"/>");
                    out.println("  <parameter name=\"java.naming.factory.url.pkgs\" value=\"org.jboss.naming:org.jnp.interfaces\"/>");
                } else if (this.containerType.equals("websphere")) {
                    out.println("  <parameter name=\"java.naming.factory.initial\" value=\"com.ibm.websphere.naming.WsnInitialContextFactory\"/>");
                    out.println("  <parameter name=\"java.naming.provider.url\" value=\"iiop://localhost:900\"/>");
                }
                out.println("  <parameter name=\"ejbLookupString\" value=\"" + this.jndiName + "\"/>");
                if (exposeHome) {
                    out.println("  <parameter name=\"instance-schemaPath\" value=\"schema/" + this.servicePathName + "Home.wsdl\"/>");
                    out.println("  <parameter name=\"skeletonClassName\" value=\"" + this.packageName + "." + this.serviceName + "HomeServiceProvider" + "\"/>");
                } else {
                    out.println("  <parameter name=\"instance-schemaPath\" value=\"schema/" + this.servicePathName + ".wsdl\"/>");
                    out.println("  <parameter name=\"skeletonClassName\" value=\"" + this.packageName + "." + this.serviceName + "ServiceImpl" + "\"/>");
                }
                out.println(" </service>");
                out.println();
                out.println("</deployment>");
                out.close();
                in.close();
                FileOutputStream fout = new FileOutputStream(fileName);
                fout.write(byteOut.toByteArray());
                fout.close();
                System.out.println("Modified " + fileName + " you may need to change the jndi properties.");
                return;
            }
            out.println(line);
            line = in.readLine();
        }
        in.close();
    }

    private File getGeneratedJavaFile(String name) {
        File packageDir = new File(this.generatedDir, this.packageName.replace('.', '/'));
        return new File(packageDir, name + ".java");
    }

    private void fixRemoteSoapBindingStub(String remoteClassName) throws IOException {
        String path = this.servicePathName.substring(0, this.servicePathName.lastIndexOf(47));
        File file = new File(this.generatedDir, path + "/RemoteSoapBindingStub.java");
        BufferedReader in = new BufferedReader(new FileReader(file));
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(byteOut);
        String line = in.readLine();
        while (line != null) {
            if (line.startsWith("public class RemoteSoapBindingStub")) {
                int pos = line.indexOf("implements ");
                out.print(line.substring(0, pos + 11));
                out.print(remoteClassName + ", ");
                out.println(line.substring(pos + 11));
            } else if (line.equals("}")) {
                out.println("    //added by org.globus.ogsa.utils.EJBServiceBuilder to implement the real remote inteface");
                out.println("    public javax.ejb.EJBHome getEJBHome() throws java.rmi.RemoteException {");
                out.println("        throw new java.rmi.RemoteException(\"Operation not supported, get the home service instead.\");");
                out.println("    }");
                out.println();
                out.println("    public javax.ejb.Handle getHandle() throws java.rmi.RemoteException {");
                out.println("        throw new java.rmi.RemoteException(\"Operation not supported, use the grid service handle instead.\");");
                out.println("    }");
                out.println();
                out.println("    public java.lang.Object getPrimaryKey() throws java.rmi.RemoteException {");
                out.println("        throw new java.rmi.RemoteException(\"Operation not supported, your remote interface should override this method if you want to use it.\");");
                out.println("    }");
                out.println();
                out.println("    public boolean isIdentical(javax.ejb.EJBObject obj) throws java.rmi.RemoteException {");
                out.println("        throw new java.rmi.RemoteException(\"Operation not supported, your remote interface should override this method if you want to use it.\");");
                out.println("    }");
                out.println();
                out.println("    public void remove() throws java.rmi.RemoteException {");
                out.println("        throw new java.rmi.RemoteException(\"Operation not supported, remove using the grid service instead.\");");
                out.println("    }");
                out.println();
                out.println("}");
            } else {
                out.println(line);
            }
            line = in.readLine();
        }
        in.close();
        out.close();
        FileOutputStream fout = new FileOutputStream(file);
        fout.write(byteOut.toByteArray());
        fout.close();
    }

    private void writeSkeleton(Class interfaceToWrite, boolean isHome, Class remoteInterface) throws IOException {
        String skelClassName = this.serviceName + "ServiceImpl";
        String extendsClassName = "EJBServiceImpl";
        if (isHome) {
            skelClassName = this.serviceName + "HomeServiceProvider";
            extendsClassName = "EJBHomeFactoryProvider";
        }
        String remoteVar = Character.toLowerCase(this.serviceName.charAt(0)) + this.serviceName.substring(1);
        File file = this.getGeneratedJavaFile(skelClassName);
        file.getParentFile().mkdirs();
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        out.println("/**This file was generated by org.globus.ogsa.utils.EJBServiceBuilder*/");
        out.println("package " + this.packageName + ";");
        out.println();
        out.println("import javax.ejb.EJBHome;");
        out.println("import javax.ejb.EJBObject;");
        out.println("import org.globus.ogsa.impl.core.service.EJBServiceImpl;");
        out.println("import org.globus.ogsa.impl.core.factory.EJBHomeFactoryProvider;");
        out.println("import org.globus.ogsa.ServiceProperties;");
        out.println();
        out.println("public class " + skelClassName + " extends " + extendsClassName + " {");
        out.println();
        if (!isHome) {
            out.println("    private " + this.serviceName + " " + remoteVar + ";");
            out.println();
        }
        out.println("    public " + skelClassName + "(EJBHome home, EJBObject remote) {");
        out.println("        super(\"" + this.serviceName + " ejb skeleton\", home, remote);");
        if (isHome) {
            out.println("        setProperty(ServiceProperties.INSTANCE_SCHEMA_PATH, \"schema/" + this.servicePathName + ".wsdl\");");
        } else {
            out.println("        " + remoteVar + " = (" + this.serviceName + ") remote;");
        }
        out.println("    }");
        out.println();
        Class cl = interfaceToWrite;
        while (cl != null && !cl.equals(class$javax$ejb$EJBObject == null ? EJBServiceBuilder.class$("javax.ejb.EJBObject") : class$javax$ejb$EJBObject)) {
            if (isHome) {
                String homeName = interfaceToWrite.getName();
                homeName = homeName.substring(homeName.lastIndexOf(46) + 1);
                homeName = "((" + homeName + ")home)";
                this.printMethods(cl.getDeclaredMethods(), out, homeName, isHome, remoteInterface);
            } else {
                this.printMethods(cl.getDeclaredMethods(), out, remoteVar, isHome, remoteInterface);
            }
            cl = cl.getSuperclass();
        }
        out.println("}");
        out.close();
    }

    private void printMethods(Method[] methods, PrintWriter out, String varName, boolean isHome, Class remoteInterface) {
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            boolean isCreateMethod = false;
            if (Modifier.isPublic(m.getModifiers())) {
                int j;
                if (isHome && remoteInterface.equals(m.getReturnType())) {
                    isCreateMethod = true;
                    out.print("    synchronized public String ");
                } else {
                    out.print("    public " + EJBServiceBuilder.getTypeName(m.getReturnType()) + " ");
                }
                out.print(m.getName() + "(");
                Class<?>[] params = m.getParameterTypes();
                int j2 = 0;
                while (j2 < params.length) {
                    out.print(EJBServiceBuilder.getTypeName(params[j2]) + " p" + j2);
                    if (j2 < params.length - 1) {
                        out.print(", ");
                    }
                    ++j2;
                }
                out.print(")");
                Class<?>[] exc = m.getExceptionTypes();
                if (exc != null && exc.length > 0) {
                    out.print(" throws ");
                    j = 0;
                    while (j < exc.length) {
                        out.print(exc[j].getName());
                        if (j < exc.length - 1) {
                            out.print(", ");
                        }
                        ++j;
                    }
                }
                out.println(" {");
                out.print("            ");
                if (isCreateMethod) {
                    out.print("            EJBObject remote = ");
                } else if (!m.getReturnType().equals(Void.TYPE)) {
                    out.print("return ");
                }
                out.print(varName + "." + m.getName() + "(");
                j = 0;
                while (j < params.length) {
                    out.print("p" + j);
                    if (j < params.length - 1) {
                        out.print(", ");
                    }
                    ++j;
                }
                out.println(");");
                if (isCreateMethod) {
                    out.println("            EJBServiceImpl skel = new " + this.serviceName + "ServiceImpl(home, remote);");
                    out.print("            String pathClue = ");
                    if (params.length == 0) {
                        out.println(" null;");
                    } else {
                        out.println("\"\" + p0;");
                    }
                    out.println("            return createRemoteService(skel, pathClue);");
                }
                out.println("    }");
                out.println();
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(Arrays.asList(args));
            if (args.length < 7) {
                System.out.println("ERROR: wrong arguments, call this with the ant build file");
                return;
            }
            String dirName = args[0];
            String homeClassName = args[1];
            String remoteClassName = args[2];
            String serverConfigFileName = args[3];
            String serviceUrl = args[4];
            String containerType = args[5];
            boolean isSecure = args[6].equalsIgnoreCase("true");
            String servPathName = null;
            if (args.length > 7 && args[7].length() > 1) {
                servPathName = args[7];
            }
            if (remoteClassName.indexOf(".") == -1) {
                System.out.println("ERROR: The ejb must be part of a package, like some.package.EJBService");
                System.exit(1);
            }
            EJBServiceBuilder sb = new EJBServiceBuilder(dirName, homeClassName, remoteClassName, servPathName, containerType, isSecure);
            Class<?> home = Class.forName(homeClassName);
            Class<?> remote = Class.forName(remoteClassName);
            if (args[3].equals("writeHomeSkel")) {
                System.out.println("writing home skeleton");
                sb.writeSkeleton(home, true, remote);
                sb.writeSkeleton(remote, false, null);
            } else {
                boolean exposeHome = sb.getGeneratedJavaFile(sb.serviceName + "HomeServiceProvider").exists();
                sb.buildService(home, remote, serviceUrl, exposeHome);
                sb.checkServerConfig(serverConfigFileName, exposeHome);
                sb.fixRemoteSoapBindingStub(remoteClassName);
            }
            sb.writeAntProperties(homeClassName, remoteClassName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeAntProperties(String homeClassName, String remoteClassName) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(new File(this.dir, "service.properties")));
        out.println("serviceName=" + this.serviceName);
        out.println("servicePackage=" + this.servicePathName.substring(0, this.servicePathName.length() - this.serviceName.length() - 1));
        out.println("homeClassFile=" + homeClassName.replace('.', '/') + ".class");
        out.println("remoteClassFile=" + remoteClassName.replace('.', '/') + ".class");
        out.close();
    }

    public static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                int i = 0;
                while (i < dimensions) {
                    sb.append("[]");
                    ++i;
                }
                return sb.toString();
            }
            catch (Throwable e) {
            }
        }
        return type.getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

