/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import java.rmi.RemoteException;
import java.util.Calendar;
import javax.xml.rpc.Stub;
import org.gridforum.ogsi.ExtendedDateTimeType;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.Factory;
import org.gridforum.ogsi.InfinityType;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.TerminationTimeType;
import org.gridforum.ogsi.holders.ExtensibilityTypeHolder;
import org.gridforum.ogsi.holders.LocatorTypeHolder;
import org.gridforum.ogsi.holders.TerminationTimeTypeHolder;

public class GridServiceFactory {
    private Factory factory;
    private TerminationTimeType time;
    private ExtensibilityType extensibilityOutput;

    public GridServiceFactory(Factory factory) {
        this.factory = factory;
    }

    public LocatorType createService() throws RemoteException {
        return this.createService(null, null, null);
    }

    public LocatorType createService(ExtensibilityType creationParameters) throws RemoteException {
        return this.createService(null, null, creationParameters);
    }

    public LocatorType createService(Calendar timeout) throws RemoteException {
        return this.createService(timeout, null, null);
    }

    public LocatorType createService(String id) throws RemoteException {
        return this.createService(null, id, null);
    }

    public LocatorType createService(Calendar timeout, String id) throws RemoteException {
        return this.createService(timeout, id, null);
    }

    public LocatorType createService(Calendar timeout, String id, ExtensibilityType creationParameters) throws RemoteException {
        if (id != null) {
            ((Stub)this.factory)._setProperty("org.globus.ogsa.InvocationID", (Object)id);
        }
        TerminationTimeType terminationTime = new TerminationTimeType();
        ExtendedDateTimeType dateTime = new ExtendedDateTimeType();
        if (timeout == null) {
            dateTime.setValue(InfinityType.infinity);
        } else {
            dateTime.setValue(timeout);
        }
        terminationTime.setAfter(dateTime);
        terminationTime.setBefore(dateTime);
        LocatorTypeHolder locator = new LocatorTypeHolder();
        TerminationTimeTypeHolder currentTime = new TerminationTimeTypeHolder();
        ExtensibilityTypeHolder extensibilityOutputParam = new ExtensibilityTypeHolder();
        this.factory.createService(terminationTime, creationParameters, locator, currentTime, extensibilityOutputParam);
        this.time = currentTime.value;
        this.extensibilityOutput = extensibilityOutputParam.value;
        return locator.value;
    }

    public TerminationTimeType getTerminationTime() {
        return this.time;
    }

    public ExtensibilityType getExtensibilityOutput() {
        return this.extensibilityOutput;
    }

    public Stub getStub() {
        return (Stub)this.factory;
    }

    public Factory getFactory() {
        return this.factory;
    }
}

