/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class QNameUtils {
    public static boolean equalsLocally(QName q1, QName q2) {
        return q1 != null && (q1.equals(q2) || q1.getNamespaceURI().equals("") && q1.getLocalPart().equals(q2.getLocalPart()));
    }

    public static QName toQName(String qname) {
        String namespaceURI = "";
        String localPart = "";
        int localPartIndex = qname.indexOf(";");
        if (localPartIndex == -1) {
            localPart = qname;
        } else {
            namespaceURI = qname.substring(0, localPartIndex);
            localPart = qname.substring(localPartIndex + 1, qname.length());
        }
        return new QName(namespaceURI, localPart);
    }

    public static QName[] toQNames(String names) {
        StringTokenizer tokenizer = new StringTokenizer(names, ",");
        QName[] qnames = new QName[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            String qname = (String)tokenizer.nextElement();
            qnames[i] = QNameUtils.toQName(qname);
            ++i;
        }
        return qnames;
    }

    public static String toString(QName[] qnames) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < qnames.length) {
            String namespace = qnames[i].getNamespaceURI();
            if (!namespace.equals("")) {
                buffer.append(namespace);
                buffer.append(";");
            }
            buffer.append(qnames[i].getLocalPart());
            if (i != qnames.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }
}

