/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.utils.MessageUtils;

public class SweeperPool {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$utils$SweeperPool == null ? (class$org$globus$ogsa$utils$SweeperPool = SweeperPool.class$("org.globus.ogsa.utils.SweeperPool")) : class$org$globus$ogsa$utils$SweeperPool).getName());
    private static SweeperPool pool = new SweeperPool();
    private ArrayList timerPool = new ArrayList();
    private int numThreads = 1;
    private int interval = 5000;
    private int currentTimer = 0;
    static /* synthetic */ Class class$org$globus$ogsa$utils$SweeperPool;

    public SweeperPool() {
        try {
            String sweeperInterval;
            String sweeperThreads = ContainerConfig.getConfig().getOption("sweeperThreads");
            if (sweeperThreads != null) {
                try {
                    this.numThreads = Integer.parseInt(sweeperThreads);
                }
                catch (Exception e) {
                    logger.error((Object)MessageUtils.toString(e));
                }
            }
            if ((sweeperInterval = ContainerConfig.getConfig().getOption("sweeperInterval")) != null) {
                try {
                    this.interval = Integer.parseInt(sweeperInterval);
                }
                catch (Exception e) {
                    logger.error((Object)MessageUtils.toString(e));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
        }
        this.startTimers();
    }

    public SweeperPool(int numThreads, int interval) {
        this.numThreads = numThreads;
        this.interval = interval;
        this.startTimers();
    }

    public static SweeperPool getDefaultPool() {
        return pool;
    }

    public synchronized void addTask(TimerTask task) {
        this.addTask(task, this.interval, this.interval);
    }

    public synchronized void addTask(TimerTask task, long delay, long period) {
        this.getNextTimer().schedule(task, delay, period);
    }

    public synchronized void addTask(TimerTask task, long delay) {
        this.getNextTimer().schedule(task, delay);
    }

    private Timer getNextTimer() {
        Timer timer = (Timer)this.timerPool.get(this.currentTimer);
        ++this.currentTimer;
        if (this.currentTimer == this.numThreads) {
            this.currentTimer = 0;
        }
        return timer;
    }

    public synchronized void stopTimers() {
        if (this.timerPool.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.numThreads) {
            Timer timer = (Timer)this.timerPool.get(i);
            timer.cancel();
            ++i;
        }
        this.timerPool.clear();
    }

    public synchronized void startTimers() {
        if (!this.timerPool.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.numThreads) {
            Timer timer = new Timer();
            this.timerPool.add(timer);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

