/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

public class SystemInfo {
    protected long totalMemory = -1L;
    protected long freeMemory = -1L;
    protected long usedMemory = -1L;
    protected String osArch = "";
    protected String osName = System.getProperty("os.name");
    protected String osVersion = "";

    public static void main(String[] args) {
        try {
            SystemInfo systemInfo = new SystemInfo();
            System.out.println("Memory:");
            System.out.println("    Total:   " + systemInfo.getTotalMemory());
            System.out.println("    Free:    " + systemInfo.getFreeMemory());
            System.out.println("    Used:    " + systemInfo.getUsedMemory());
            System.out.println("");
            System.out.println("OS:");
            System.out.println("    Name:    " + systemInfo.getOSName());
            System.out.println("    Version: " + systemInfo.getOSVersion());
            System.out.println("    Arch:    " + systemInfo.getOSArch());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SystemInfo() throws Exception {
        this.osArch = System.getProperty("os.arch");
        this.osVersion = System.getProperty("os.version");
        this.update();
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public String getOSName() {
        return this.osName;
    }

    public String getOSArch() {
        return this.osArch;
    }

    public String getOSVersion() {
        return this.osVersion;
    }

    protected void update() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        this.totalMemory = runtime.totalMemory();
        this.freeMemory = runtime.freeMemory();
        this.usedMemory = this.totalMemory - this.freeMemory;
    }
}

