package org.ecoinformatics.ecogrid.lsid;

import java.io.*;
import java.net.*;

//import java.sql.Connection;
import java.util.ResourceBundle;

import com.ibm.lsid.LSID;
import com.ibm.lsid.server.LSIDServerException;

public class LSIDDataLookup {

//	private static Connection lsidLookup = null;

	public static final int UNKNOWN = 1;
	public static final int ABSTRACT = 2;
	public static final int CONCRETE = 4;


	public LSIDDataLookup() throws LSIDServerException {
        System.out.println("Creating LSIDDataLookup (Metacat).");
  	}


	public int lsidType(LSID lsid) throws LSIDServerException {

		int result = CONCRETE;
		return result;
	}

	public InputStream lsidData(LSID lsid) throws LSIDServerException {
		String ns = lsid.getNamespace();
		String id = lsid.getObject();
		String ver = lsid.getRevision();
		InputStream docStream = null;
		

		// example metacat query
		// http://metacat.nceas.ucsb.edu/knb/metacat?action=read&qformat=xml&docid=knb-lter-gce.109.6
		//
		
    ResourceBundle rb = ResourceBundle.getBundle("metacat");
    String theServer = rb.getString("metacatserver");
		System.out.println("the server is " + theServer);

		String url = theServer + "?action=read&qformat=xml&docid=";
		url = url + ns + "." + id + "." + ver;
		try {
			URL theDoc = new URL(url);
			docStream  = theDoc.openStream();
		} catch (MalformedURLException mue) {
         		System.out.println("MalformedURLException in LSIDDataLookup: " + mue);
         		mue.printStackTrace();
   		} catch (IOException ioe) {
         		System.out.println("IOException in LSIDDataLookup: " + ioe);
         		ioe.printStackTrace();
		}


		return docStream;
	}

}
