/**
 *    '$RCSfile: AuthorizationServiceClient.java,v $'
 *
 *     '$Author: tao $'
 *       '$Date: 2008-01-31 01:52:54 $'
 *   '$Revision: 1.2 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2009 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.ecogrid.client;

import org.ecoinformatics.ecogrid.EcogridUtils;

import org.ecoinformatics.ecogrid.authorize.stub.AuthorizationServicePortType;
import org.ecoinformatics.ecogrid.authorize.stub.AuthorizationServiceLocator;
import org.ecoinformatics.ecogrid.authorize.stub.AuthorizationServiceIsAuthorizedRequestElementType;

/**
 * authentication client for the ecogrid
 */
public class AuthorizationServiceClient {
	private String serviceURL = null;
	private AuthorizationServicePortType ecogrid = null;

	/**
	 *  The main program for the AuthorizationServiceClient class
	 *
	 *@param  args  The command line arguments
	 */
	public static void main(String[] args) {
		String opMode = "";
		String sessionId = "";
		String resourceLsid = "";
		String permission = "";
		String gsh_str = "";

		if (args.length != 5) {
			PrintAuthUsage();
			System.exit(0);
		} else {
			opMode = args[0];

			if (opMode.compareToIgnoreCase("isAuthorized") == 0) {
				System.out.println("checking is authorized");
				sessionId = args[1];
				resourceLsid = args[2];
				permission = args[3];			
				gsh_str = args[4];
			} else {
				PrintAuthUsage();
				System.exit(0);
			}
		}

		try {
			// create a client object
			AuthorizationServiceClient client = new AuthorizationServiceClient(gsh_str);
			if (opMode.compareToIgnoreCase("isAuthorized") == 0) {
				client.is_authorized_action(sessionId, resourceLsid, permission);
			} 
		} catch (Exception e) {
			// System.out.println("Exception in main : "+ e.getMessage());
			e.printStackTrace();
		}

	}

	//main

	/**
	 *  Constructor for the AuthorizationServiceClient object
	 *
	 *@param  serviceGSH     Description of the Parameter
	 *@exception  Exception  Description of the Exception
	 */
	public AuthorizationServiceClient(String serviceGSH) throws Exception {
		this.serviceURL = serviceGSH;
		EcogridUtils.setDebug(true);
		// Get a reference to the AuthenticationService Factory
		long startFactory = System.currentTimeMillis();

		AuthorizationServiceLocator loc = new AuthorizationServiceLocator();

		ecogrid = loc.getAuthorize(new java.net.URL(serviceURL));

		org.apache.axis.client.Stub stub = (org.apache.axis.client.Stub) ecogrid;

		stub.setTimeout(10000000);
		long endInstance = System.currentTimeMillis();

		EcogridUtils.debugMessage("The time to create instance is =========== "
				+ (endInstance - startFactory) / 1000, 30);
	}

	/**
	 * login to the ecogrid and get a sessionid
	 * 
	 *@param  UserName       Description of the Parameter
	 *@param  PassWord       Description of the Parameter
	 *@return                Description of the Return Value
	 *@exception  Exception  Description of the Exception
	 */
	public String is_authorized_action(String sessionId, String resourceLsid, String permission) throws Exception {
		String retStr;

		AuthorizationServiceIsAuthorizedRequestElementType isAuthorizedReq = new AuthorizationServiceIsAuthorizedRequestElementType();
		isAuthorizedReq.setSessionId(sessionId);
		isAuthorizedReq.setResourceLsid(resourceLsid);
		isAuthorizedReq.setPermission(permission);
		retStr = ecogrid.isAuthorized(isAuthorizedReq);

		System.out.println("AuthorizationServiceClient.login_action - return string: "
				+ retStr);
		return retStr;
	}

	/**
	 * print the usage statement
	 */
	private static void PrintAuthUsage() {
		System.out.println("Usage: java org.ecoinformatics.ecogrid.client.AuthorizationServiceClient isAuthorized sessionId resourceLsid permission GSH");
	}

}
