/**
 *    '$RCSfile: IdentifierServiceClient.java,v $'
 *
 *     '$Author: leinfelder $'
 *       '$Date: 2008-01-19 22:10:17 $'
 *   '$Revision: 1.7 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2007 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.ecogrid.client;

import java.io.FileInputStream;
import java.net.URL;

import org.ecoinformatics.ecogrid.*;
import org.ecoinformatics.ecogrid.lsid.*;
import org.ecoinformatics.ecogrid.lsid.stub.*;

/**
 * client to handle identifier service requests
 */
public class IdentifierServiceClient
{
  IdentifierServicePortType ecogrid;

  private String serviceURL = null;

  /**
   *  The main program for the IdentifierServiceClient class
   *
   *@param  args  The command line arguments
   */
  public static void main(String[] args)
  {
    if(args.length < 2)
    {
      // System.out.println("Usage: java org.ecoinformatics.ecogrid.client.EcogridPutClient quer|get filename GSH");
      System.out.println("Usage: java org.ecoinformatics.ecogrid.client.IdentifierServiceClient url <lsid> action");
      System.out.println("  Where action is either 'add', 'isRegistered', 'nextRev', 'nextObj', or getallids");
      System.exit(0);
    }

    String url = args[0];
    String lsid = args[1];
    String action = args[2];
    System.out.println("lsid is: " + lsid);
    System.out.println("url is: " + url);
    System.out.println("action: " + action);

    try
    {
      IdentifierServiceClient client = new IdentifierServiceClient(url);
      //client calls here
      if(action.equals("isRegistered"))
      {
        boolean b = client.isRegistered(lsid);
        System.out.println("answer is " + b);
      }
      else if(action.equals("add"))
      {
        String s = client.addLSID(lsid);
        System.out.println("answer is " + s);
      }
      else if(action.equals("nextRev"))
      {
        String s = client.getNextRevision(lsid);
        System.out.println("answer is " + s);
      }
      else if(action.equals("nextObj"))
      {
        String s = client.getNextObject(lsid);
        System.out.println("answer is " + s);
      }
      else if(action.equals("getallids"))
      {
        String s = client.getAllIds(lsid);
        System.out.println("answer is " + s);
      }
      else
      {
        System.out.println("Incorrect action " + action);
      }
    }
    catch(Exception e)
    {
      // System.out.println("Exception in main : "+ e.getMessage());
      e.printStackTrace();
    }

  }
  //main

  /**
   *  Constructor for the IdentifierServiceClient object
   *
   *@param  url            Description of the Parameter
   *@exception  Exception  Description of the Exception
   */
  public IdentifierServiceClient(String url)
    throws Exception
  {
    this.serviceURL = url;
    // Get a reference to the EcoGridQueryLevelOneService Factory
    long startFactory = System.currentTimeMillis();

    IdentifierServiceLocator loc = new
        IdentifierServiceLocator();

    ecogrid = loc.getIdentifier(new java.net.URL(serviceURL));

    org.apache.axis.client.Stub stub = (org.apache.axis.client.Stub)ecogrid;

    stub.setTimeout(10000000);
    long endInstance = System.currentTimeMillis();

    EcogridUtils.debugMessage("The time to create instance is =========== " +
        (endInstance - startFactory) / 1000, 30);
  }

  /**
   *  Gets the registered attribute of the IdentifierServiceClient object
   *
   *@param  lsid                          Description of the Parameter
   *@return                               The registered value
   *@exception  java.rmi.RemoteException  Description of the Exception
   */
  public boolean isRegistered(String lsid)
    throws java.rmi.RemoteException
  {
    return new Boolean(ecogrid.isRegistered(lsid)).booleanValue();
  }

  /**
   *  Gets the nextRevision attribute of the IdentifierServiceClient object
   *
   *@param  lsid                          Description of the Parameter
   *@return                               The nextRevision value
   *@exception  java.rmi.RemoteException  Description of the Exception
   */
  public String getNextRevision(String lsid)
    throws java.rmi.RemoteException
  {
    return ecogrid.getNextRevision(lsid);
  }

  /**
   *  Gets the nextObject attribute of the IdentifierServiceClient object
   *
   *@param  lsid                          Description of the Parameter
   *@return                               The nextObject value
   *@exception  java.rmi.RemoteException  Description of the Exception
   */
  public String getNextObject(String lsid)
    throws java.rmi.RemoteException
  {
    return ecogrid.getNextObject(lsid);
  }

  /**
   *  Adds a feature to the LSID attribute of the IdentifierServiceClient object
   *
   *@param  lsid                          The feature to be added to the LSID
   *      attribute
   *@return                               Description of the Return Value
   *@exception  java.rmi.RemoteException  Description of the Exception
   */
  public String addLSID(String lsid)
    throws java.rmi.RemoteException
  {
    return ecogrid.addLSID(lsid);
  }

  /**
   *  Gets the allIds attribute of the IdentifierServiceClient object
   *
   *@param  partialLSID                   Description of the Parameter
   *@return                               The allIds value
   *@exception  java.rmi.RemoteException  Description of the Exception
   */
  public String getAllIds(String partialLSID)
    throws java.rmi.RemoteException
  {
    return ecogrid.getAllIds(partialLSID);
  }
}

