/**
 *  '$RCSfile: EcogridQueryToMetacatQueryTransformer.java,v $'
 *    Purpose: A Class that applies an XSLT stylesheet to ecogrid queries so that they become
 *    			metacat query documents
 *  Copyright: 2000 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Ben Leinfelder
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-01-17 23:07:41 $'
 * '$Revision: 1.1 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.metacat.authenticatedqueryservice.impl;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EcogridQueryToMetacatQueryTransformer {
	public static final String XSLT_FILENAME = "/xsd/xslt/ecogridToPathquery.xsl";

	private static Logger log = Logger.getLogger(EcogridQueryToMetacatQueryTransformer.class);

	/**
	 * Default constructor
	 * 
	 */
	public EcogridQueryToMetacatQueryTransformer() {

	}
	
	public static Reader ecogrid2Metacat(Reader ecogridQuery) {
		Node queryNode = parseXML(ecogridQuery);
		log.info("parsed the ecogrid query xml");
		Reader pathQuery = transformXML(queryNode);
		log.info("transformed the ecogrid query xml to pathquery xml");
		return pathQuery;
	}
	
	public static Reader ecogrid2Metacat(String ecogridQueryXML) {
		Reader ecogridQuery = new StringReader(ecogridQueryXML);
		return ecogrid2Metacat(ecogridQuery);
	}
	
	private static Node parseXML(Reader xmlInput) {
		Node queryNode = null;
		try {
			InputSource in = new InputSource(xmlInput);
			DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
			dfactory.setNamespaceAware(false);
			Document doc = dfactory.newDocumentBuilder().parse(in);
		      
			// Find the query node, all searches are relative to it.
			NodeList queryIdList = XPathAPI.selectNodeList(doc, "/query");
			queryNode = queryIdList.item(0);
		}
		catch (Exception e) {
			log.error("could not parse xml document");
		}
		return queryNode;
	}
	
	private static Reader transformXML(Node queryNode) {
		log.info("transforming xml node..." + queryNode);
		Reader r = null;
		try {
			Transformer transformer = 
				TransformerFactory.newInstance().newTransformer(
						new StreamSource(
								EcogridQueryToMetacatQueryTransformer.class.getResourceAsStream(
										XSLT_FILENAME)));
			log.info("transformer is: " + transformer);
			Source source = new DOMSource(queryNode);
			StringWriter sw = new StringWriter();
			Result result = new StreamResult(sw);
			transformer.transform(source, result);
			log.info("query: " + sw.toString());
			r = new StringReader(sw.toString());
		}
		catch (Exception e) {
			log.error("could not transform xml node");
			e.printStackTrace();
		}
		return r;
	}
	
	public static void main(String[] args) {
		
		if (args.length < 1) {
			System.out.println("Usage: java  EcogridQueryToMetacatQueryTransformer <input_filename> [outputfile]");
			System.exit(0);
		}
		String in = args[0];
		String outputfile = null;
		
		if (args.length == 2) {
			outputfile = args[1];
		}
		
		try {
			File queryXMLFile = new File(in);
			FileReader xmlReader = new FileReader(queryXMLFile);
			EcogridQueryToMetacatQueryTransformer.ecogrid2Metacat(xmlReader);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
	}

}
