/**
 *  '$RCSfile: MetacatAuthenticatedQueryServiceImpl.java,v $'
 *    Purpose: A Class that implements replication for metacat
 *  Copyright: 2000 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Chad Berkley
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-10-02 18:11:16 $'
 * '$Revision: 1.4 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.metacat.authenticatedqueryservice.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.rmi.RemoteException;

import org.apache.log4j.Logger;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.AuthenticatedQueryServicePortType;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.GetElementType;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.QueryElementType;
import org.ecoinformatics.ecogrid.metacat.impl.MetacatResultsetParser;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryTypeNamespace;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridQueryTransformer;

import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;

/**
 * The class implements ecogrid query and get method for metacat
 */
public class MetacatAuthenticatedQueryServiceImpl implements
		AuthenticatedQueryServicePortType {

	private static Logger logMetacat = Logger
			.getLogger(MetacatAuthenticatedQueryServiceImpl.class);

	private static String metacatURL = "http://localhost:8080/knb/metacat";
	static {
		try {
			
			String tmp = SystemUtil.getServletURL();
			if (tmp != null && tmp.length() > 0) {
				metacatURL = tmp;
			}
		} catch (Exception e) {
			logMetacat.error("error loading metacat properties: "
					+ e.getMessage());
			e.printStackTrace(System.err);
		}
	}

	public MetacatAuthenticatedQueryServiceImpl() {
		// super("Simple Metacat Factory Service");
	}

	/**
	 * Implementation of query type
	 */
	public ResultsetType query(QueryElementType aqet) throws RemoteException {
		logMetacat.warn("start authenticated query method in grid service");
		ResultsetType records = new ResultsetType();
		try {
			// get the query part
			QueryType query = aqet.getQuery();

			// get the session part
			String sessionId = aqet.getSessionId();

			logMetacat.warn("before transforming query");

			// transform the QueryType to XML
			String ecogridQueryXML = EcogridQueryTransformer.toXMLString(query);

			// transform the ecogrid XML to pathquery XML
			Reader xmlQueryReader = EcogridQueryToMetacatQueryTransformer
					.ecogrid2Metacat(ecogridQueryXML);

			logMetacat.warn("after transforming query");

			Metacat metacat = null;
			try {
				// create instance
				metacat = MetacatFactory.createMetacatConnection(metacatURL);
				// set the session
				metacat.setSessionId(sessionId);
			} catch (Exception e) {
				logMetacat.error("could not create metacat instance for URL: "
						+ metacatURL);
			}

			// query metacat
			Reader metacatQueryResults = metacat.query(xmlQueryReader, "xml");

			// int c = metacatQueryResults.read();
			// StringBuffer sb = new StringBuffer();
			// while (c > -1) {
			// sb.append((char)c);
			// c = metacatQueryResults.read();
			// }
			// logMetacat.info("!!!!!!!!!result is: " + sb.toString());

			// parse and transform the metacat results to an ecogrid result
			String saxparser = PropertyService.getProperty("xml.saxparser");

			QueryTypeNamespace[] namespaces = query.getNamespace();
			String[] namespaceStrings = new String[namespaces.length];
			for (int i = 0; i < namespaces.length; i++) {
				namespaceStrings[i] = namespaces[i].get_value();
			}
			MetacatResultsetParser parser = new MetacatResultsetParser(
					metacatQueryResults, saxparser, namespaceStrings);

			records = parser.getEcogridResult();

			// right now just throw away the session
			// TODO: BRL 20071126 implement the authenticated query
			// logMetacat.warn("autheticated query is not yet
			// implemented!!!!!");
			// records = query(query);

		}// try
		catch (Exception e) {
			logMetacat.warn("The exception is: " + e.getMessage());
			throw new RemoteException(e.getMessage());
		}// catch
		return records;
	}// authQuery

	/**
	 * Implementation of get method
	 */
	// public byte[] authGet(String identifier) throws RemoteException
	public byte[] get(GetElementType authElement) throws RemoteException {
		return get(authElement.getIdentifier(), authElement.getSessionId());
	}

	private byte[] get(String identifier, String sessionId)
			throws RemoteException {
		// String sessionId = null; //testing
		byte[] output;

		if (identifier == null) {
			throw new RemoteException("Please specify an identifier");
		}
		logMetacat.warn("in get method.  identifier=" + identifier);

		if (sessionId == null) {
			throw new RemoteException(
					"Please provide an authentication credential (sessionId)");
		}
		logMetacat.warn("sessionId=" + sessionId);

		Metacat metacat = null;
		try {
			metacat = MetacatFactory.createMetacatConnection(metacatURL);
		} catch (Exception e) {
			logMetacat.error("could not create metacat instance for URL: "
					+ metacatURL);
		}

		// set the credential
		metacat.setSessionId(sessionId);

		// get the requested document
		try {

			InputStream br = null;
			// TODO: ask about inlinedata??
			boolean inLineData = false;
			if (inLineData) {
				br = metacat.readInlineData(identifier);
			} else {
				br = metacat.read(identifier);
			}

			int c = br.read();
			ByteArrayOutputStream content = new ByteArrayOutputStream();
			while (c > -1) {
				content.write(c);
				c = br.read();
			}
			output = content.toByteArray();

			logMetacat.warn("after reading doc content");
		}// try
		catch (Exception e) {
			logMetacat.warn("in exception e" + e.getMessage());
			throw new RemoteException(e.getMessage());
		}// catch
		return output;
	}// get

}
