/**
 *    Purpose: A Class that implements put service for metacat data mgmt system.
 *  Copyright: 2004 Regents of the University of California and
 *             San Diego Supercomputer Center
 *    Authors: Bing Zhu 
 *             Sept 14, 2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.metacat.authorize;

import java.rmi.RemoteException;

import org.apache.log4j.Logger;
import org.ecoinformatics.ecogrid.authorize.stub.AuthorizationServiceIsAuthorizedRequestElementType;
import org.ecoinformatics.ecogrid.authorize.stub.AuthorizationServicePortType;

import edu.ucsb.nceas.metacat.client.MetacatClient;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;

/**
 * The class implements Metacat authentication service
 */
public class MetacatAuthorizeImpl implements AuthorizationServicePortType {
	// Actual value is set by metacat configuration
	private static String metacatUrl = "http://indus.nceas.ucsb.edu/knb-oracle/metacat";
	private static Logger logMetacat = Logger.getLogger(MetacatAuthorizeImpl.class);
	static {
		try {
			String tmp = SystemUtil.getServletURL();
			if (tmp != null && tmp.length() > 0) {
				metacatUrl = tmp;
				System.out.println("MetacatAuthorizeImpl() - metacatUrl set to: "
						+ metacatUrl);
			}
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
	}

	public MetacatAuthorizeImpl() {
	}

	// EcogridUtils.debugMessage("UploadMetacatMetadata() exception: " + e.getMessage());
	// throw new RemoteException(e.getMessage());
	// public java.lang.String login(java.lang.String userName, java.lang.String passWord) throws RemoteException
	public String isAuthorized(AuthorizationServiceIsAuthorizedRequestElementType isAuthorizedRequest)
			throws RemoteException {
		logMetacat.debug("MetacatAuthorizeImpl.isAuthorized - resourceLsid: "
				+ isAuthorizedRequest.getResourceLsid() + 
				" permission: " + isAuthorizedRequest.getPermission() +
				" sessionId: + " + isAuthorizedRequest.getSessionId());
		
		String authString = null;
		try {

			MetacatClient m = 
				(MetacatClient) MetacatFactory.createMetacatConnection(metacatUrl);

			String resourceLsid = isAuthorizedRequest.getResourceLsid();
			String permission = isAuthorizedRequest.getPermission();
			String sessionId = isAuthorizedRequest.getSessionId();
			
			authString = m.isAuthorized(resourceLsid, permission, sessionId);
		} catch (Exception e) {

			e.printStackTrace(System.err);
			throw new RemoteException(e.getMessage());
		}

		logMetacat.debug("MetacatAuthorizeImpl.isAuthorized - result: " + authString);

		return authString;
	}
}
