/**
 *  '$RCSfile: MetacatResultsetParser.java,v $'
 *    Purpose: A Class that implements replication for metacat
 *  Copyright: 2000 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Chad Berkley
 *    Release: @release@
 *
 *   '$Author: tao $'
 *     '$Date: 2008-04-23 16:41:04 $'
 * '$Revision: 1.5 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ecoinformatics.ecogrid.metacat.impl;

import java.io.Reader;
import java.util.TimeZone;
import java.util.Calendar;
import java.util.Date;

import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;

import org.apache.axis.types.URI;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataNamespace;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeRecord;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadata;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeRecordReturnField;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataSystem;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataRecordStructure;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataRecordStructureReturnField;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridResultsetFactory;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import java.sql.Timestamp;

/**
 * This class will parse metacat resultset - A reader to Ecogrid Resultset
 * object. This one record for a document
 *<document>
 * <docid>docid</docid><docname>docname</docname><doctype>doctype </doctype>
 * <createdate>createDate </createdate><updatedate>updateDate</updatedate>
 * <param name="returnfield1">returnvalue</param>
 * <param name="returnfield2">returnvalue</param>
 * <triple><subject>subject</subject><subjectdoctype>type</subjectdoctype>
 *         <relationship>relation</relationship>
 *         <object>object</object><objectdoctype>type</objectdoctype>
 * </triple>
 *</document>
 * @author Jing Tao
 */

public class MetacatResultsetParser extends DefaultHandler
{
  private String                 _parserName         = null;
  private ResultsetType          _ecogridResult      = new ResultsetType();
  private ResultsetTypeResultsetMetadata 
                                 _metadata           = new ResultsetTypeResultsetMetadata();
  private ResultsetTypeRecord[] _recordList         = null;
  private ResultsetTypeRecord   _currentRecord      = new ResultsetTypeRecord();
  private StringBuffer           _textBuffer         = new StringBuffer();
  private StringBuffer           _namespace          = new StringBuffer();
  private Vector                 _tmpRecordList      = new Vector();
  private Vector                 _tmpReturnFieldList = new Vector();
  private long                   _number             = 0;
  private String                 _currentTag         = null;
  private boolean                _inTriple           = false;
  private StringBuffer           _name               = new StringBuffer();
  
  private long                   _fieldCounter       = 0;
  private Hashtable              _recStructIdHastable = new Hashtable();
  private String[]                    searchNamespace     = null;
  //constant
  private static final String PARAM     = "param";
  private static final String TRIPLE    = "triple";


  /**
   * Default constructor
   * @param metacatResult Reader  the xml sourc need to be parsed
   * @param _parserName String     the name of xml sax parser
   */
  public MetacatResultsetParser(Reader metacatResult, String _parserName, String[] searchNameSpace)
                                throws Exception
  {
  	EcogridUtils.setDebug(true);
     if (metacatResult == null)
     {
       throw new Exception("couldn't find metacat resultset source");
     }
     if (_parserName == null)
     {
       throw new Exception("couldn't find parsername in MetacatREsultsetParse");
     }
     this._parserName = _parserName;
     
     // set system
     _ecogridResult.setSystem(new URI("http://knb.ecoinformatics.org"));
     
     // set resultsetId
     _ecogridResult.setResultsetId("eml.001");     
     this.searchNamespace = searchNameSpace;
     
     // set meta data

     // set send time
     TimeZone local = TimeZone.getTimeZone(System.getProperty("user.timezone"));
     Calendar calendar = Calendar.getInstance(local);
     Date now = new Date();
     calendar.setTime(now);
     _metadata.setSendTime(calendar);
     
	 ResultsetTypeResultsetMetadataSystem system[] = new ResultsetTypeResultsetMetadataSystem[1];
	 system[0] = EcogridResultsetFactory.createSystem("http://ecogrid.ecoinformatics.org", "0");
     //system[0] = EcogridUtils.createSystem("http://dev.nceas.ucsb.edu", "0");
	 _metadata.setSystem(system);
	 // use multiple namespaces
	 ResultsetTypeResultsetMetadataNamespace[] namespaces = 
		 new ResultsetTypeResultsetMetadataNamespace[this.searchNamespace.length];
	 for (int i= 0; i < searchNameSpace.length; i++) {
		 namespaces[i] = new ResultsetTypeResultsetMetadataNamespace(searchNamespace[i]);
	 }
     _metadata.setNamespace(namespaces);
    		 

     // Initialize the parser and read the resultset
     XMLReader parser = initializeParser();
     parser.parse(new InputSource(metacatResult));
     
     // Create Record Structures
     int inx = 0;
     ResultsetTypeResultsetMetadataRecordStructure recordStructure = new ResultsetTypeResultsetMetadataRecordStructure();
     Vector returnFieldVector = new Vector();
     for (Enumeration e = _recStructIdHastable.keys(); e.hasMoreElements() ;) {
       String    nameSpace  = (String)e.nextElement();
       Hashtable retFldHash = (Hashtable)_recStructIdHastable.get(nameSpace);
       //records[inx] = EcogridUtils.createRecordStruct(nameSpace);
       
       int fldInx = 0;
       //ResultsetType_resultsetMetadata_recordStructure_returnField fields[] = new ResultsetType_resultsetMetadata_recordStructure_returnField[retFldHash.size()];
       for (Enumeration ef = retFldHash.keys(); ef.hasMoreElements() ;) {
         String fieldName = (String)ef.nextElement();
         String fieldId   = (String)retFldHash.get(fieldName);
         //fields[fldInx++] = EcogridUtils.createRecordStructReturnField(fieldId, null, fieldName);
         ResultsetTypeResultsetMetadataRecordStructureReturnField field = 
                 EcogridResultsetFactory.createRecordStructReturnField(fieldId, nameSpace, fieldName);
         returnFieldVector.addElement(field);
       }
       
     }
     ResultsetTypeResultsetMetadataRecordStructureReturnField[] fieldArray = 
         new  ResultsetTypeResultsetMetadataRecordStructureReturnField[returnFieldVector.size()];
    fieldArray = (ResultsetTypeResultsetMetadataRecordStructureReturnField[])
                 returnFieldVector.toArray(fieldArray);
    recordStructure.setReturnField(fieldArray);
    _metadata.setRecordStructure(recordStructure);
  }

  /**
   * Set up the SAX parser for reading the XML result set
   */
  private XMLReader initializeParser() throws Exception
  {
    XMLReader parser = null;

    // Set up the SAX document handlers for parsing
    try
    {
        // Get an instance of the parser
        parser = XMLReaderFactory.createXMLReader(_parserName);

        // Set the ContentHandler to this instance
        parser.setContentHandler(this);

        // Set the error Handler to this instance
        parser.setErrorHandler(this);

    }
    catch (Exception e)
    {
        System.err.println("Error in QuerySpcecification.initializeParser " + e.toString());
        throw e;
    }

    return parser;
  }

  /**
   * Method to get Ecogrid result set after parsing
   * @return ResultsetType
   */
  public ResultsetType getEcogridResult()
  {
    return _ecogridResult;
  }

  /**
  * This method starts a new vector for each updatedDocument tag.
  */
  public void startElement(String uri, String localName, String qName,
                           Attributes attributes) throws SAXException
  {
    _currentTag = localName;
    if (localName.equals("document"))
    {
      // start a new record for current record
      _currentRecord = new ResultsetTypeRecord();
      _number ++;
      _currentRecord.setNumber(_number);
      _currentRecord.setSystem("0");
    }
    else if (localName.equals(PARAM))
    {
      getValueOfNamedAttr(attributes, "name", _name);
    }
    else if (localName.equals(TRIPLE))
    {
      _inTriple = false;
    }

    //handle triple subtree
    if (_inTriple)
    {
      // Not sure what to do here?
      //getValueOfNamedAttr(attributes, "name", _name);
      //EcogridUtils.debugMessage("***** localName["+localName+"]");
    }
  }
  
  /**
   * This method ...
   */
   public String getFieldId(String aFieldName, String aNameSpace)
   {
     Hashtable hash = (Hashtable)_recStructIdHastable.get(aNameSpace);
     if (hash == null){
       hash = new Hashtable();
       _recStructIdHastable.put(aNameSpace, hash);
     }
     String fieldId = (String)hash.get(aFieldName);
     if (fieldId == null) {
       fieldId = "f" + _fieldCounter;
       hash.put(aFieldName, fieldId);
       _fieldCounter++;
     }
     return fieldId;
   }
   
 /**
  * This method write the indivUpdate to updates when it finds the end of
  */
  public void endElement(String uri, String localName, String qName)
             throws SAXException
  {
     if (localName.equals("docid"))
     {
       String docid = _textBuffer.toString();
       if (docid != null)
       {
         docid = docid.trim();
       }
       _currentRecord.setIdentifier(docid);
     }
     else if (localName.equals("doctype"))
     {
       _namespace.setLength(0);
       _namespace.append(_textBuffer.toString());
       EcogridUtils.debugMessage("**** namespace["+_namespace+"]");
       // XXX _currentRecord.setNamespace(namesapce);
     }
     else if (localName.equals("createdate"))
     {
       String createDateString = _textBuffer.toString();
       Calendar createTime  = transformStringToTimestamp(createDateString);
       _currentRecord.setCreationDate(createTime);
     }
     else if (localName.equals("updatedate"))
     {
       String updateDateString = _textBuffer.toString();
       Calendar updateTime    = transformStringToTimestamp(updateDateString);
       _currentRecord.setLastModifiedDate(updateTime);
     }
     else if (localName.equals(PARAM))
     {
       
       String nameId = getFieldId(_name.toString(), _namespace.toString());
       ResultsetTypeRecordReturnField returnField = EcogridResultsetFactory.createRecordReturnField(nameId, _textBuffer.toString());
       _tmpReturnFieldList.add(returnField);       
     }
     else if (localName.equals(TRIPLE))
     {
       // XXX not sure what to do here
       _inTriple = false;
     }
     else if (localName.equals("document"))
     {
       // combine param and triple string buffer into one string and set it
       // to ResultsetType_record object
       ResultsetTypeRecordReturnField returnFields[] = new ResultsetTypeRecordReturnField[_tmpReturnFieldList.size()];
       for (int i=0;i<_tmpReturnFieldList.size();i++) {
         returnFields[i] = (ResultsetTypeRecordReturnField)_tmpReturnFieldList.elementAt(i);
       }
       _tmpReturnFieldList.clear();
       _currentRecord.setReturnField(returnFields);
       
       _tmpRecordList.add(_currentRecord);
     }

     //handle subtree of triple
     if (_inTriple)
     {
       // XXX ???
     }

     //reset textbuffer
     _textBuffer.setLength(0);
  }

 /**
  * Take the data out of the docid and date_updated fields
  */
 public void characters(char[] ch, int start, int length) throws SAXException
 {
     while (length > 0 && (ch[start] == '\n' || ch[start] == '\r')) {
      start++;
      length--;
     }
     if (length > 0){
       _textBuffer.append(new String(ch, start, length));
     }
 }

 /**
  * In the end of doucment, transfer the tempRecordList vector to the array -
  * _recordList and set the array to Resultset object
  */
 public void endDocument()
 {
    int size = _tmpRecordList.size();
    // if size is zero, it start 0
    if ( size == 0)
    {
      _metadata.setStartRecord(size);
    }
    else
    {
      _metadata.setStartRecord(1);
    }
    _metadata.setEndRecord(size);
    _metadata.setRecordCount(size);
    _ecogridResult.setResultsetMetadata(_metadata);
    _recordList = new ResultsetTypeRecord[size];
    for (int i = 0; i<size; i++)
    {
      ResultsetTypeRecord record = (ResultsetTypeRecord)_tmpRecordList.elementAt(i);
      _recordList[i] = record;
    }
    _ecogridResult.setRecord(_recordList);
 }

 /*
  * Method to transfer a string to time stamp
  */
  private Calendar transformStringToTimestamp(String str)
  {
    // this is hack for postgresql. In postgresql the value yyyy-mm-dd
    // but it should be yyyy-mm-dd hh-mm-ss
    if (str.indexOf(":") == -1)
    {
      str = str + " 00:00:00";
    }
    Timestamp time = Timestamp.valueOf(str);
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(time);
    return calendar;
  }

  private boolean getValueOfNamedAttr(Attributes attributes,
                                      String aAttrName,
                                      StringBuffer buffer)
  {
    // Add all of the attributes
    for (int i = 0; i < attributes.getLength(); i++)
    {
      String attributeName = attributes.getQName(i);
      String attributeValue = attributes.getValue(i);
      if (attributeName.equals(aAttrName)) {
        buffer.setLength(0);
        buffer.append(attributeValue);
        return true;
      }
    }
    return false;
  }

  /*private ResultsetType_resultsetMetadata_recordStructure findRecStructByNameSpace(String aNameSpace)
  {
    if (aNameSpace == null) {
      EcogridUtils.debugMessage("findRecStructByNameSpace - aNameSpace is null!");
      return null;
    }
	ResultsetType_resultsetMetadata_recordStructure recStructs = _metadata.getRecordStructure();
    if (recStructs != null) {
  	  for (int i=0;i<recStructs.length;i++) {
  		  if (aNameSpace.equals(recStructs[i].getNamespace())) {
  			     return recStructs[i];
  		  }
      }
	  }
	  return null;
  }*/
  
  private boolean isNameAlreadyThere(String aName, ResultsetTypeResultsetMetadataRecordStructureReturnField aFields[])
  {
    if (aName == null) {
      EcogridUtils.debugMessage("isNameAlreadyThere - aName is null!");
      return false;
    }
    if (aFields == null) {
      EcogridUtils.debugMessage("isNameAlreadyThere - aFields is null!");
      return false;
    }
	  for (int i=0;i<aFields.length;i++) {
		  if (aName.equals(aFields[i].getName())) {
			return true;
		  }
	  }
	  return false;
  }
  
}