package org.ecoinformatics.ecogrid.queryservice.util;

import java.util.Calendar;

import org.ecoinformatics.ecogrid.queryservice.resultset.*;

public class EcogridResultsetFactory
{
  /**
	   * Creates a Metadata System object
	   * @param aURIStr URI for the name space
	   * @param aId the id
	   */
  public static ResultsetTypeResultsetMetadataSystem createSystem(String aURIStr, String aId) {
    ResultsetTypeResultsetMetadataSystem system = new ResultsetTypeResultsetMetadataSystem(aURIStr);
    system.setId(aId);
    return system;
  }

  /**
	   * Creates a Metadata NameSpace object
	   * @param aVal value of the the namespace (the namespace)
	   * @param aPrefix the prefix for the namespace
	   */
  public static ResultsetTypeResultsetMetadataNamespace createNameSpace(String aVal, String aPrefix) {
    ResultsetTypeResultsetMetadataNamespace namespace = new ResultsetTypeResultsetMetadataNamespace(aVal);
    namespace.setPrefix(aPrefix);
    return namespace;
  }

    /**
	   * Creates a recordStructure returnField
	   * @param aId unique id for return field (definition)
	   * @param aPathNS the namespace for the path
	   * @param aName the name that the id is really substituting for
	   */
    public static ResultsetTypeResultsetMetadataRecordStructureReturnField createRecordStructReturnField(String aId, String aPathNS, String aName) {
    	ResultsetTypeResultsetMetadataRecordStructureReturnField returnField = new ResultsetTypeResultsetMetadataRecordStructureReturnField();
    	returnField.setId(aId);
    	returnField.setPathns(aPathNS);
    	returnField.setName(aName);
      return returnField;
    }
    
    /**
     * Creates a recordStructure returnField
     * @param aNameSpace attrs of the return field
     */
  	public static ResultsetTypeResultsetMetadataRecordStructure createRecordStruct() {
    	ResultsetTypeResultsetMetadataRecordStructure recStruct = new ResultsetTypeResultsetMetadataRecordStructure();
      return recStruct;
    }

    /**
     * Creates a recordStructure returnField
     * @param aSendTime time the resultset was sent
     * @param aStartRecord starting record number
     * @param aEndRecord ending record number
     * @param aRecordCount record count
     */
  	public static ResultsetTypeResultsetMetadata createMetadata(Calendar aSendTime,
                                                                 long     aStartRecord,
                                                                 long     aEndRecord,
                                                                 long     aRecordCount) {
      ResultsetTypeResultsetMetadata metadata = new ResultsetTypeResultsetMetadata();
      metadata.setSendTime(aSendTime);
      metadata.setStartRecord(aStartRecord);
      metadata.setEndRecord(aEndRecord);
      metadata.setRecordCount(aRecordCount);
      return metadata;
    }
  
  /**
   * Creates a record returnField
   * @param aId unique id for return field (definition)
   * @param aName the name that the id is really substituting for
   * @param aContent the content of the returnField
   */
	public static ResultsetTypeRecordReturnField createRecordReturnField(String aId, String aContent) {
  	ResultsetTypeRecordReturnField returnField = new ResultsetTypeRecordReturnField();
  	returnField.setId(aId);
  	returnField.set_value(aContent);
    return returnField;
  }

}
