/**
 *  '$RCSfile: EcogridJSPBaseBean.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *  Purpose: To test the MetaCatURL class by JUnit
 *    Authors: @Rod Spears@
 *    Release: @release@
 *
 *   '$Author: rspears $'
 *     '$Date: 2004-06-10 13:08:19 $'
 * '$Revision: 1.10 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package org.ecoinformatics.ecogrid.registry.impl;

import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.EcogridResultsetTransformer;
import org.ecoinformatics.ecogrid.EcogridResultsetParser;
import org.ecoinformatics.ecogrid.ResultsetType;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * Ecogrid JSP Bean - Helper class to aid in reusability of functionality
 * needed for JSP pages. This encapsulates all the SOAP calls from JSP
 *
 * @author  Rod Spears
 */
abstract class EcogridJSPBaseBean
{

  /**
   * Constructor
   */
  public EcogridJSPBaseBean()
  {
    EcogridUtils.setDebug(true);
    EcogridUtils.debugMessage("Created EcogridJSPBaseBean.");
  }

  abstract String getXMLListing(String aUrl);

  /**
   * Returns an HTML table listing of all registry entries
   * @param aUrl URL of service to be run
   * @return returns an HTML table string of all the entries in the registry
   */
  public String getHTMLListing(String aUrl)
  {
    EcogridUtils.debugMessage("*************************************");
    EcogridUtils.debugMessage("*************************************");
    EcogridUtils.debugMessage("********getHTMLListing*************");

    if (aUrl == null) return null;

    String xmlStr = getXMLListing(aUrl);
    if (xmlStr == null) return null;

    String htmlStr = null;
    boolean ok = false;
    StringBuffer tableStr = new StringBuffer("<table border=1>\n");
    tableStr.append("<tr><td align=center><b>Resource Name</b></td><td align=center><b>Registry Name</b></td><td align=center><b>Registry Address</b></td></tr>\n");
    Document dom = EcogridUtils.convertXMLStr2DOM(xmlStr);
    if (dom != null)
    {
      Node listing = EcogridUtils.findNode(dom, "listing");
      if (listing != null) 
      {
        NodeList list = listing.getChildNodes();
        ok = list.getLength() > 0;
        for (int i=0;i<list.getLength();i++) 
        {
          Node child = list.item(i);
          if (child != null && child.getNodeType() != Node.TEXT_NODE)
          {
            tableStr.append("<tr><td align=center>"+EcogridUtils.findNodeValue(child, "name")+
                           "</td><td align=center>"+EcogridUtils.findNodeValue(child, "regName")+
                           "</td><td>"+EcogridUtils.findNodeValue(child, "regAddr")+"</td></tr>\n");
          }
        }
      }
    }

    if (!ok) 
    {
      tableStr.append("<tr><td align=center colspan=3>No Entries in Registry</td></tr>\n");
    }
    tableStr.append("</table>");

    return tableStr.toString();
  }


 
  /**
   * Converts XML Resultset String to an HTML Table using a DOM
   * @param aResultset XML String representing the resultset
   * @return true on success, false on failure
   */
  public String formatResultsetToHTMLTableFromString(String aResultset)
  {
  	return EcogridResultsetParser.formatResultsetToHTMLTableUsingDOM(aResultset);
  }


  /**
   * Converts Resultset to an HTML Table
   * @param aResultset XML String representing the resultset
   * @return true on success, false on failure
   */
  public String formatResultsetToHTMLTable(ResultsetType aResultset)
  {
    if (aResultset == null) return "The Resultset was null!";
    return EcogridResultsetParser.formatResultsetToHTMLTableUsingDOM(EcogridResultsetTransformer.toXMLString(aResultset));
  }

}
