<!--
/*
 *  The UI consists of several arrays that define the contents of the UI
 *  Although, it could have done with objects, this "seemed" easier at the time. (I may have been wrong)
 *  
 *  So each line in the query UI consists of a index in the arrays. 
 *  Conditions can be nested.
 *  
 */
var conditionsOptions  = ["AND", "OR"];
var comparatorsOptions = ["LIKE", "NOT LIKE", "EQUALS", "NOT EQUALS", "LESS THAN", "LESS THAN OR EQUALS", "GREATER THAN", "GREATER THAN OR EQUALS"];

var title            = "";
var namespace_prefix = "";
var namespace        = "";
var gUrl             = "kuecogrid.ittc.ku.edu:8080/ogsa";

var rowType     = new Array(0);
var fieldNames  = new Array(0);
var comparators = new Array(0);
var fieldValues = new Array(0);
var conditions  = new Array(0);
var numConds    = 0;

var depth        = 0;
var curDepth     = 0;
var curCondType  = new Array(0);
var maxDepth     = 0;

var lastType     = -1;

var returnFields = new Array(0);
var numReturns   = 0;

var bgColors = ["#FFE0E0", "#E0E0E0", "#E0FFFF", "#E0E0FF", "#E0FFE0", "#FFFFE0", "#FFE0FF"];


/*
 * Checks to see what kind of browser we are using
 * It must be IE 6 and NS 6 and up
 */
function checkVersion()
{
  // Browser Sniffer Code
  var agent = navigator.userAgent.toLowerCase();

  // *** BROWSER VERSION ***
  // Note: On IE5, these return 4, so use is_ie5up to detect IE5.
  var is_major = parseInt(navigator.appVersion);
  var is_minor = parseFloat(navigator.appVersion);

  // Note: Opera and WebTV spoof Navigator.  We do strict client detection.
  // If you want to allow spoofing, take out the tests for opera and webtv.
  var isNav     = ((agent.indexOf('mozilla')!=-1) && (agent.indexOf('spoofer')==-1) && (agent.indexOf('compatible') == -1) && (agent.indexOf('opera')==-1) && (agent.indexOf('webtv')==-1));
  var isNav4    = (isNav && (is_major == 4));
  var isNav4up  = (isNav && (is_major >= 4));
  var isNavonly = (isNav && ((agent.indexOf(";nav") != -1) ||  (agent.indexOf("; nav") != -1)) );
  var isNav5up  = (isNav && (is_major >= 5));
  var isNav6up  = (isNav && (is_major >= 5));

  // added the Gecko sniffing which is unique to Netscape 6
  //var isNav6 = (agent.indexOf("gecko") != -1);
  //if (isNav6) { is_major = 6;}
  var isIE   = (agent.indexOf("msie") != -1);
  var isIE3  = (isIE && (is_major < 4));
  var isIE4  = (isIE && (is_major == 4) && (agent.indexOf("msie 4.") != -1) );
  var isIE4up  = (isIE  && (is_major >= 4));
  var isIE5  = (isIE && (is_major == 4) && (agent.indexOf("msie 5.") != -1) );
  var isIE6  = (isIE && (is_major == 4) && (agent.indexOf("msie 6.") != -1) );
  var isIE5up  = (isIE  && !isIE3 && !isIE4);
  if (isIE5 && (is_major == 4)) { is_major = 5; }

  if (isFirstTime == "true") {
    if (isIE) {
      alert("Some queries will not submit in IE (bug in IE)\nIf you construct a query and it doesn't submit\nplease use Netscape or Mozilla.");

    } else if (!isNav6up && !isIE6) {
      alert("You must using Netscape 6.x or 7.x, or IE 5.x or 6.x Browser");
    }
  }
}


/*
 * Gets HTML table cells that are used to indent the UI depending on the nesting
 */
function getIdentCells(num, useWhiteBG)
{
  if (num < 1) {
    return "";
  }

  var str = "";
  var i;
  for (i=0;i<num;i++) {
    var color = "white";
    if (!useWhiteBG) {
      color = bgColors[(i+1) % bgColors.length ];
    }
    str += "<td style=\"font-family:monospace;background-color:"+color+"\">&nbsp;&nbsp;</td>\n";
  }
  return str;
}

/*
 * This is called by the select at the end of each line
 * and it adds or removes UI
 */
function doAction(inx, type, theSelect)
{
  if (theSelect.value == "remove") {
    if (type == 0) {
      removeField(inx);

    } else if (type == 1) {
      removeCond(inx);

    } else if (type == 2) {
      removeClose(inx);
    }

  } else if (theSelect.value == "insertFieldBelow") {
    addRow(inx, 0, 0, "", "", 0, true);

  } else if (theSelect.value == "insertCondBelow") {
    addRow(inx, 2, 0, "", "", 0, false);
    addRow(inx, 0, 0, "", "", 0, false);
    addRow(inx, 0, 0, "", "", 0, false);
    addRow(inx, 1, 0, "", "", 0, true);
  }
}

/*
 * Builds the select UI for each row, adds different items depending on the type
 * and where it is at and how many are there
 */
function getActionSelect(inx, type)
{
  var str = "<select id=\"actionSelect_"+inx+"\" size=\"1\" onchange=\"doAction("+inx+", "+type+", this);\">\n";
  str += "  <option value=\"\">Choose Action</option>\n";
  if (type != 2) {
    str += "  <option value=\"remove\">Remove item</option>\n";
  }
  if (inx != 0 || type != 0) {
    str += "  <option value=\"insertFieldBelow\">Insert Field</option>\n";
    str += "  <option value=\"insertCondBelow\">Insert Condition</option>\n";
  }
  str += "</select>\n";
  return str;
}

/*
 * Creates a field Name/Value UI
 */
function createField(inx)
{
  var tmpDepth = depth;
  if (tmpDepth == 0) {
    tmpDepth++;
  }
  var color = bgColors[tmpDepth % bgColors.length ];
  var str = "<tr>\n";
  str += "<td><table border=0 cellspacing=\"0\" cellpadding=\"5\">\n<tr>";
  str += getIdentCells(depth, false);
  str += "<td bgcolor=\"" + color + "\">\n  <input type=text name=fieldNames_" + inx + " id=fieldNames_" + inx + " size=30 value=\""+ fieldNames[inx] + "\" onblur=\"buildXMLQuery()\"></td>\n";
  str += "<td align=center bgcolor=\"" + color + "\">\n  <select size=1 name=comparators_" + inx + " id=comparators_" + inx + ">\n";
  var i;
  for (i=0;i<comparatorsOptions.length;i++) {
    var selected = "";
    if (i == comparators[inx]) {
      selected = " selected"; 
    }
    str += "    <option value=\"" + comparatorsOptions[i] +"\"" + selected+">" +  comparatorsOptions[i] + "</option>\n";
  }
  str += "  </select></td>\n";
  str += "<td bgcolor=\"" + color + "\">\n  <input type=text name=fieldValues_" + inx + " id=fieldValues_" + inx + " size=30 value=\""+ fieldValues[inx] + "\" onblur=\"buildXMLQuery()\"></td>\n";
  str += "<td bgcolor=\"" + color + "\">\n  " + getActionSelect(inx, 0) + "</td>\n";
  str += "</tr></table>\n</td>\n";

  str += "</tr>\n";

  return str;
}

/*
 * Creates a condition UI
 */
function createCondition(inx)
{
  curCondType[depth] = conditions[inx];

  var color = bgColors[(depth+1) % bgColors.length ];
  var str = "<tr>"

  str += "<td><table border=0 cellspacing=\"0\" cellpadding=\"5\">\n<tr>";
  str += getIdentCells(depth, false);
  str += "<td align=left bgcolor=\"" + color + "\">";
  str += "<select size=1 name=conditions_" + inx + " id=conditions_" + inx + " onchange=\"createForm();\">\n";

  for (i=0;i<conditionsOptions.length;i++) {
    var selected = "";
    if (i == conditions[inx]) {
      selected = " selected"; 
    }
    str += "<option value=\"" + conditionsOptions[i] +"\""+ selected + ">" +  conditionsOptions[i] + "</option>\n";
  }

  str += "</select></td>\n<td bgcolor=\"" + color + "\">\n  " + getActionSelect(inx, 1) + "</td>\n";
  str += "</tr>\n</table>\n</td>\n";
  str += "</tr>\n";

  depth++;

  return str;
}

/*
 * Creates a close UI
 */
function createClose(inx)
{
  depth--;
  var i = numConds - 1;

  while (i > 0 && rowType != 1) {
    i--;
  }

  var select = document.getElementById('conditions_'+ i);
  var selectedInx = 0;
  if (select != null) {
    selectedInx = select.selectedIndex;
  }

  //alert(depth + "  " + curCondType[depth] + "  " + conditionsOptions[curCondType[depth]]);

  var color = bgColors[(depth+1) % bgColors.length ];

  var str = "<tr><td><table border=\"0\"  cellspacing=\"0\" cellpadding=\"5\">\n<tr>";
  str += getIdentCells(depth, false);
  str += "<td bgcolor=\"" + bgColors[(depth+1) % bgColors.length ] + "\">\n  <span style=\"font-family:arial;font-size:10pt;\">&lt;/" + conditionsOptions[curCondType[depth]]  +"&gt;</span>";
  //str += "<input type=hidden name=\"close_" + inx + "\" value=\"x\">";
  str += "</td>\n";
  if (inx < numConds - 1) {
    str += "<td bgcolor=\"" + color + "\">\n  " + getActionSelect(inx, 2) + "</td>\n";
  }
  str += "</tr></table>\n</td>\n</tr>\n";

  return str;
}

/*
 * Generic add "row" that "switched" off of the row type 
 * to determine what UI needs to be added
 */
function createRowUI(inx)
{
  var str = "";
  if (rowType[inx] == 0) {
    str += createField(inx);

  } else if (rowType[inx] == 1) {
    str += createCondition(inx);

  } else {
    str += createClose(inx);
  }

  return str;
}

/*
 * Shifts all the items in the arrays down one row
 */
function slideDown(inx)
{
  captureCurrentValues();

  var i;
  for (i=numConds;i>inx;i--) {
    rowType[i]     = rowType[i-1];
    fieldNames[i]  = fieldNames[i-1];
    comparators[i] = comparators[i-1];
    fieldValues[i] = fieldValues[i-1];
    conditions[i]  = conditions[i-1];

    if (document.getElementById('fieldNames_'+ i) != null) {
      document.getElementById('fieldNames_'+ i).value          = fieldNames[i];
      document.getElementById('comparators_'+ i).selectedIndex = comparators[i];
      document.getElementById('fieldValues_'+ i).value         = fieldValues[i];
    } else if (document.getElementById('conditions_'+ i) != null) {
      document.getElementById('conditions_'+ i).value = conditions[i];
    }
  }
}

/*
 * Generic add "row" that simply sets the info in the array of query UI elements
 * Note: it will insert and shift items down
 */
function addRow(inx, type, comparator, fieldName, fieldValue, condition, doCreateForm)
{
  var newInx = inx+1;

  slideDown(newInx);

  rowType[newInx]     = type;
  fieldNames[newInx]  = fieldName;
  comparators[newInx] = comparator;
  fieldValues[newInx] = fieldValue;
  conditions[newInx]  = condition;

  numConds++;

  if (doCreateForm) {
    createForm();
  }
}

/*
 * Given the text of a comparator it returns the index
 */
function getComparatorIndexForValue(value)
{
  var i;
  for (i=0;i<comparatorsOptions.length;i++) {
    if (value == comparatorsOptions[i]) {
    return i;
    }
  }
  return 0;
}

/*
 * Given the text of a condition it returns the index
 */
function getConditionIndexForValue(value)
{
  var i;
  for (i=0;i<conditionsOptions.length;i++) {
    if (value == conditionsOptions[i]) {
      return i;
    }
  }
  return 0;
}

/*
 * Adds a "row" representing a field/value pair to the internal info
 * this info is used to build the UI
 */
function addField(comparator, fieldName, fieldValue, doCreateForm)
{

  addRow(numConds-1, 0, getComparatorIndexForValue(comparator), fieldName, fieldValue, 0, doCreateForm);
}

/*
 * Adds a "row" representing a condition to the internal info
 * this info is used to build the UI
 */
function addCondition(condition, doCreateForm)
{
  addRow(numConds-1, 1, 0, "", "", getConditionIndexForValue(condition), doCreateForm);
}

/*
 * Adds a "row" representing a "close" of a condition to the internal info
 * this info is used to build the UI
 */
function addClose(doCreateForm)
{
  addRow(numConds-1, 2, 0, "", "", 0, doCreateForm);
}

/*
 * Adds a "row" representing a return field to the internal info
 * this info is used to build the UI
 */
function addReturn(fieldValue, doCreateForm)
{
  returnFields[numReturns] = fieldValue;
  numReturns++;

  if (doCreateForm) {
    createForm();
  }
}

/*
 * Creates the HTML UI table row that is a Return Field
 * called indirectly by the createForm function
 */
function createReturn(inx)
{
  var str = "<tr><td><input type=text name=\"returnFields_" + inx + "\" id=\"returnFields_" + inx + 
            "\" size=60 value=\""+ returnFields[inx] + "\" onblur=\"buildXMLQuery()\"></td>\n";

  str +=    "<td><input type=button id=\"clearField_" + inx + 
            "\" onclick=\"document.getElementById(\'returnFields_" + inx + "').value = \'\';\" value=\"Clear\"></td>\n";

  str +=    "<td><input type=button id=\"removeField_" + inx + 
            "\" onclick=\"removeReturn("+inx+");\" value=\"Remove\"></td>\n";
  str += "</tr>\n";

  return str;
}

/*
 * Fill in the Header UI with values
 */
function fillInHeaderValues(aTitle, aNS, aNSP)
{
  if (document.getElementById('title') != null && aTitle != null) {
    document.getElementById('title').value = aTitle;
  }

  if (document.getElementById('namespace') != null && aNS != null) {
    document.getElementById('namespace').value = aNS;
  }

  if (document.getElementById('namespace_prefix') != null && aNSP != null) {
    document.getElementById('namespace_prefix').value = aNSP;
  }
}

/*
 * Gets a value from a named control and 
 * returns the control value, or the default value or ""
 */
function getTextControlValue(name, defValue)
{
  var defValIsGood = defValue != null && defValue != "";

  var control = document.getElementById(name);
  if (control != null) {
    var value = control.value;
    if ((value == null || value == "")) {
      if( defValIsGood) {
        return defValue;
      } else {
      return "";
      }
    } else {
      return value;
    }
  }
  return defValIsGood ? defValue : "";
}

/*
 * Capture all the values out of the UI and put it into the arrays
 */
function captureCurrentValues()
{

  title            = getTextControlValue('title', title);
  namespace        = getTextControlValue('namespace', namespace);
  namespace_prefix = getTextControlValue('namespace_prefix', namespace_prefix);

  // Capture current values before adding next row
  var i;
  for (i=0;i<numConds;i++) {
    lastType = rowType[i];
    if (rowType[i] == 0 && document.getElementById('fieldNames_'+ i) != null) {
      fieldNames[i]  = document.getElementById('fieldNames_'+ i).value;
      comparators[i] = document.getElementById('comparators_'+ i).selectedIndex;
      fieldValues[i] = document.getElementById('fieldValues_'+ i).value;
      conditions[i]  = -1;

    } else if (rowType[i] == 1 && document.getElementById('conditions_'+ i) != null) {
      fieldNames[i]  = null;
      comparators[i] = -1;
      fieldValues[i] = null;
      conditions[i]  = document.getElementById('conditions_'+ i).selectedIndex;
    }
  }

  for (i=0;i<numReturns;i++) {
    var fieldCtrl = document.getElementById('returnFields_'+ i);
    if (fieldCtrl != null) {
      returnFields[i] = fieldCtrl.value;
    }
  }
}

/*
 * Remove a condition
 */
function removeCond(inx)
{
  captureCurrentValues();

  // The Hard Part
  // search for and find the ending of the condition
  if (inx > -1 && inx < numConds) {
    var endInx = inx+1;
    var tmpDepth = 0;

    while (endInx < (numConds-1)) {
      if (rowType[endInx] == 2) {
        if (tmpDepth == 0) {
          break;
        }
        tmpDepth--;

      } else if (rowType[endInx] == 1) {
        tmpDepth++;
      }
      endInx++;
    }

    //alert( "  inx "+inx + "  endInx "+endInx+ "  numConds "+numConds);

    // Shift all the fields up
    var numToSubtract = endInx - inx + 1;

    var ok = true;
    if (numToSubtract > 2) {
      document.getElementById('actionSelect_'+ inx).selectedIndex = 0;
      ok = confirm("Are you sure you want to delete the condition?");
    }
    if (!ok) return;

    //inx--;
    endInx++;
    for (i=endInx;endInx<numConds;endInx++) {

      rowType[inx]     = rowType[endInx];
      fieldNames[inx]  = fieldNames[endInx];
      comparators[inx] = comparators[endInx];
      fieldValues[inx] = fieldValues[endInx];
      conditions[inx]  = conditions[endInx];

      //alert("Moving "+endInx+" to "+inx+"  ["+fieldNames[inx]+"]");

      if (document.getElementById('fieldNames_'+ inx) != null) {
        document.getElementById('fieldNames_'+ inx).value          = fieldNames[endInx];
        document.getElementById('comparators_'+ inx).selectedIndex = comparators[endInx];
        document.getElementById('fieldValues_'+ inx).value         = fieldValues[endInx];

      } else if (document.getElementById('conditions_'+ inx) != null) {
        document.getElementById('conditions_'+ inx).value = conditions[endInx];
      }
      inx++;
    }

    //alert("substracting: " + numToSubtract);
    numConds -= numToSubtract;
  } else {
    numConds--;
  }

  createForm();

}

/*
 * Remove a return Field Name and Field Value "line"
 */
function removeField(inx)
{
  captureCurrentValues();

  numConds--;

  // Shift everything up
  if (inx > -1 && inx < numConds) {
    var i;
    for (i=inx;i<numConds;i++) {
      rowType[i]     = rowType[i+1];
      fieldNames[i]  = fieldNames[i+1];
      comparators[i] = comparators[i+1];
      fieldValues[i] = fieldValues[i+1];
      conditions[i]  = conditions[i+1];

      if (document.getElementById('fieldNames_'+ i) != null) {
        document.getElementById('fieldNames_'+ i).value          = fieldNames[i];
        document.getElementById('comparators_'+ i).selectedIndex = comparators[i];
        document.getElementById('fieldValues_'+ i).value         = fieldValues[i];

      } else if (document.getElementById('conditions_'+ i) != null) {
        document.getElementById('conditions_'+ i).value = conditions[i];
      }

      //alert("Moving "+(i+1)+" to "+i+"  ["+fieldNames[i]+"]");
    }
  }

  createForm();

}

/*
 * Remove a return field
 */
function removeReturn(inx)
{
  captureCurrentValues();

  numReturns--;

  if (inx > -1 && inx < numReturns) {
    var i;
    for (i=inx;i<numReturns;i++) {
      returnFields[i] = returnFields[i+1];
      //alert("Moving "+(i+1)+" to "+i+"  ["+returnFields[i]+"]");

      if (document.getElementById('returnFields_'+ i) != null) {
        //alert("Moving "+(i+1)+" to "+i+"  ["+returnFields[i]+"]");
        document.getElementById('returnFields_'+ i).value = returnFields[i];
      }
    }
  }

  createForm();

}

/*
 * Remove a condition's close "tag"
 */
function removeClose()
{
  numConds--;

  createForm();

}

/*
 * Sets a value in the form if the ontrol is there
 */
function setValueInControl(name, value)
{
  var control = document.getElementById(name);
  if (control != null) {
    control.value = value;
  }
}

/*
 * Clears all the query UI info so a new one can be built
 */
function startOver()
{
  numConds   = 0;
  numReturns = 0;

  createForm();
}

/*
 * Clears all the query UI info so a new one can be built
 */
function selectResource(resName)
{
  var select = document.getElementById("resource");
  if (select) {
    var options = select.options;
    var i;
    for (i=0;i<options.length;i++) {
      if (options[i].value == resName) {
        select.selectedIndex = i;
        return;
      }
    }
  }
}

/*
 * Clears all the query UI info so a new one can be built
 */
function buildXMLQuery()
{
 // no op for now

}

/*
 * Builds up the Uqery for submission
 * 
 * It constructs two things:
 * 
 * 1) It builds up an XML document that represents the Ecogrid query,
 *    and then stashes the XML document string into a "hidden" input
 *    named "queryStr"
 *
 * 2) Build upa string of fields that defines the query in the query builder
 *    this an enables it to easily rebuild the query UI when the results come back
 *    each field is separated by "|", we should check to make sure none of the 
 *    fields contain the separator (TODO)
 */
function submitQuery()
{
  captureCurrentValues();

  if (document.getElementById("resource").selectedIndex == -1) {
    alert("You must select a resource!");
    return false;
  }

  // Make sure the required fields are filled
  if (namespace == null || namespace.length == 0) {
    alert("The Namespace field is empty.");
    return false;
  }

  if (namespace_prefix == null || namespace_prefix.length == 0) {
    alert("The Namespace Prefix field is empty.");
    return false;
  }
  
  // Start building up the XML Ecogrid Query document as a string
  var queryStr = '';
  queryStr += '<?xml version="1.0" encoding="UTF-8"?>\n';
  queryStr += '<egq:query queryId="query-digir.1.1" system="http://knb.ecoinformatics.org" \n';
  queryStr += '  xmlns:egq="http://ecoinformatics.org/query-1.0.1" \n';
  queryStr += '  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" \n';
  queryStr += '  xsi:schemaLocation="http://ecoinformatics.org/query-1.0.1 ../../src/xsd/query.xsd">\n';
  queryStr += '  <namespace prefix="'+namespace_prefix+'">'+namespace+'</namespace>\n';
  queryStr += '  <title>'+title+'</title>\n';

  // Add return fields first (for no particular reason)
  var isAllEmpty = true;
  var i;
  for (i=0;i<numReturns;i++) {
    if (returnFields[i] != "") {
      queryStr += '  <returnfield>'+returnFields[i]+'</returnfield>\n';
      isAllEmpty = false;
    }
  }

  if (isAllEmpty && numReturns > 0) {
    alert("All the return fields are empty.");
    return false;
  }

  // Add condition and fields
  // Keep track of whether it enter a new nested condition so it know when
  // to terminate the condition
  var isOneEmpty = false;
  var stack = new Array(0);
  var stackInx = 0;
  for (i=0;i<numConds;i++) {
    if (rowType[i] == 0) {
      if (fieldNames[i] != "" && fieldValues[i] != "") {
        queryStr += "  <condition operator=\""+comparatorsOptions[comparators[i]]+"\" concept=\""+fieldNames[i]+"\">"+fieldValues[i]+"</condition>\n";
      } else {
        isOneEmpty = true;
      }

    } if (rowType[i] == 1) {
      queryStr += "  <"+conditionsOptions[conditions[i]]+">\n";
      stack[stackInx] = conditions[i];
      stackInx++;

    } if (rowType[i] == 2) {
      stackInx--;
      queryStr += "  </"+conditionsOptions[stack[stackInx]]+">\n";
    }
  }

  queryStr += '</egq:query>\n';

  // Stash the XML document into the hidden form control
  document.getElementById("queryStr").value = queryStr;

  // A couple of last second checks
  if (isOneEmpty) {
    alert("One of the fields is empty!\nThe query was not submitted.");
    return false;
  }
  //clearCurrentValues();
  return true;
}


/*
 * All of the UI except the "resource" select is constructed here
 * and put into the "div"
 */
function createForm()
{
  captureCurrentValues();

  // figure out the maximum nested dept of all the query
  depth = 0;
  maxDepth = 0;
  for (i=0;i<numConds;i++) {
    if (rowType[i] == 1) {
      depth++;
    } else if (rowType[i] == 2) {
      depth--;
    }
    if (depth > maxDepth) {
      maxDepth = depth;
    }
  }
  depth = 0;

  // Construct the "Header" UI 
  var text = "<form method=\"POST\" id=queryForm name=queryForm action=\"http://" + gUrl + "/queryForm.jsp\" onsubmit=\"return submitQuery()\">";
  text += "<input type=hidden id=\"queryStr\" name=\"queryStr\" value=\"\">";
  text += "<input type=hidden id=\"numConds\" name=\"numConds\" value=\"0\">";
  text += "<input type=hidden id=\"numReturns\" name=\"numReturns\" value=\"0\">";
  text += "<input type=hidden name=process value=\"XXX\">";

  text += "<br><table width=\"100%\"><tr><td bgcolor=\"#5B89BB\"><span class=titlebar>Ecogrid Resources:</span></td></tr></table>";
  text += "<select style=\"min-width:100px;\" size=10 id=resource name=resource>\n";
  var i;
  if (resourceSelectArray.length == 0) {
    text += "  <option value=\"\">No Items</option>\n";
  } else {
    for (i=0;i<resourceSelectArray.length;i++) {
      var selected = "";
      if (i == selectedIndex) {
        selected = "  selected";
      }
      text += "  <option value=\""+resourceSelectArray[i]+"\"" + selected + ">"+resourceSelectArray[i]+"</option>\n";
    }
  }
  text += "</select>\n<br><br>\n";

  text += "<table width=\"100%\">\n<tr><td bgcolor=\"#5B89BB\">\n  <span class=titlebar>Header:</span></td>\n</tr></table>";
  text += "<table>\n<tr><td><FIELDSET style=\"padding:0px;\"><LEGEND><b>Title</b></LEGEND><table border=0>\n<tr>";
  text += "<td align=right><b>&nbsp;</b></td>\n<td><input type=\"text\" id=title name=title size=60 value=\""+title+"\" onblur=\"buildXMLQuery()\"></td>\n</tr>\n";
  text += "</table>\n</FIELDSET></td>\n</tr></table>\n<br>";
  text += "<table>\n<tr><td><FIELDSET style=\"padding:0px;\"><LEGEND><b>Namespace</b></LEGEND><table border=0>\n";
  text += "<tr><td align=right><b>Prefix:</b></td>\n<td><input type=\"text\" id=namespace_prefix name=namespace_prefix size=30 value=\""+namespace_prefix+"\" onblur=\"buildXMLQuery()\"><span class=req>(Required)</span></td>\n</tr>\n";
  text += "<tr><td align=right><b>Value:</b></td>\n<td><input type=\"text\" id=namespace name=namespace size=60 value=\""+namespace+"\" onblur=\"buildXMLQuery()\"><span class=req>(Required)</span></td>\n</tr>\n";
  text += "</table>\n</FIELDSET></td>\n</tr>\n</table>\n<br>";
  text += "<table width=\"100%\">\n<tr><td bgcolor=\"#5B89BB\">\n  <span class=titlebar>Query:</span></td>\n</tr></table>";
  text += "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">";

  // Build up the UI for the Query
  for (i=0;i<numConds;i++) {
    text += createRowUI(i);
  }

  // Determine what needs to be disabled for when the query is empty or is there
  var disabled = " disabled";
  var startOverDisabled = "";
  if (numConds == 0) {
    disabled = "";
    startOverDisabled = " disabled";
  }

  text += "</table>\n<table>\n<tr><td><FIELDSET style=\"padding:0px;\"><LEGEND><b>Query Builder</b></LEGEND><table border=0>\n<tr>";
  text += "<td align=center><input type=\"button\" id=\"addCondBtn\" value=\"Add Condition\" onClick=\"javascript:addCondition('', false);javascript:addField('', '', '', false);javascript:addField('', '', '', false);javascript:addClose(true);\""+disabled+"></td>\n";
  text += "<td align=center><input type=\"button\" id=\"addFieldBtn\" value=\"Add Field\" onClick=\"javascript:addField('', '', '', true);\""+disabled+"></td>\n";
  text += "<td align=center><input type=\"button\" id=\"startOverBtn\" value=\"Start Over\" onClick=\"javascript:startOver();\""+startOverDisabled+"></td>\n</tr>\n";
  text += "</table>\n</FIELDSET>\n";
  text += "</td></tr></table>";

  // Construct the Retuen Fields UI
  text += "<br><table width=\"100%\">\n<tr><td bgcolor=\"#5B89BB\">\n  <span class=titlebar>Return Fields:</span></td>\n</tr></table>";
  text += "<table>";

  for (i=0;i<numReturns;i++) {
    text += createReturn(i);
  }
  text += "</table>\n<table border=0>\n<tr>";
  text += "<td align=center><input type='button' id='addReturnFieldBtn' value='Add Return Field' onClick='javascript:addReturn(\"\", true);'/></td>\n";
  text += "<td align=center>&nbsp;</td>\n";
  text += "<td align=center>&nbsp;</td>\n</tr>\n";
  text += "</table>";

  // Construct the submit button UI
  text += "<br><table width=\"100%\">\n<tr><td bgcolor=\"#5B89BB\">\n  <span class=titlebar>Do Query:</span></td>\n</tr></table>";
  text += "<br>";
  text += "<table>\n<tr><td><input type='submit' id='submit' value='Submit Query'/></td>\n";
  text += "<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\n<td><FIELDSET style=\"padding:0px;\"><LEGEND><b>Demo</b></LEGEND><table border=0>\n<tr>";
  text += "<td align=center><input type='button' value='Fill in DiGIR Query' onClick='javascript:fillInDigirQuery()'></td>\n";
  text += "<td align=center><input type='button' value='Fill in Metacat Query' onClick='javascript:fillInMetacatQuery()'></td>\n";
  text += "<td align=center><input type='button' value='Fill in SRB Query' onClick='javascript:fillInSRBQuery()'></td>\n</tr>\n<tr>";
  text += "</table>\n</FIELDSET></td>\n</tr></table>";
  text += "</form>";



  // Depending on the Browser set the contents of 
  // the "div" to the UI we just connstructed

  // IE 5 and Netscape 6
  if (document.getElementById)
  {
    document.getElementById("boxes").innerHTML = text;
  }

  //document.getElementById("debug").value = text;
  //document.getElementById("debug").value = "lastType: "+ lastType + " depth: "+ depth + "\n" + text;

  setValueInControl("numConds", numConds);
  setValueInControl("numReturns", numReturns);

  buildXMLQuery();

}

/*
 * Builds a "canned" DiGIR Query
 */
function fillInDigirQuery()
{
  startOver();

  title            = "Peromyscus genus query";
  namespace_prefix = "darwin";
  namespace        = "http://digir.net/schema/conceptual/darwin/2003/1.0";

  fillInHeaderValues(title, namespace, namespace_prefix);

  addField("LIKE", "Genus", "Peromyscus", false);

  addReturn("/ScientificName", false);
  addReturn("/Collector", false);
  addReturn("/YearCollected", true);

  selectResource("DiGIR Grid Resource");
}

/*
 * Builds a "canned" Metacat Query
 */
function fillInMetacatQuery()
{
  startOver();

  title            = "Soils Metadata Query";
  namespace_prefix = "eml";
  namespace        = "eml://ecoinformatics.org/eml-2.0.0";

  fillInHeaderValues(title, namespace, namespace_prefix);

  addCondition("AND", false);
    addCondition("OR", false);
      addField("LIKE", "title", "%soil%", false);
      addField("NOT LIKE", "title", "%dirt%", false);
    addClose(false);
    addCondition("OR", false);
      addField("LIKE", "surName", "%Jones%", false);
      addField("NOT LIKE", "surName", "%Vieglais%", false);
    addClose(false);
  addClose(false);

  addReturn("/eml/dataset/title", false);
  addReturn("/eml/dataset/creator/individualName/surName", false);
  addReturn("/eml/dataset/pubDate", false);
  addReturn("/eml/dataset/keywordSet/keyword", true);

  selectResource("Metacat Grid Resource");
}

/*
 * Builds a "canned" SRB Query
 */
function fillInSRBQuery()
{
  startOver();

  title            = "Metadata Query for Eco Models";
  namespace_prefix = "eml";
  namespace        = "eml://ecoinformatics.org/eml-2.0.0";

  fillInHeaderValues(title, namespace, namespace_prefix);

  addCondition("AND", false);
    addField("LIKE", "srbURI", "srb://testuser.sdsc:TESTUSER@srb.sdsc.edu:6617/home/testuser.sdsc", false);
    addField("EQUALS", "Number of Species", "2", false);
    addField("LIKE", "file name", "%Model%", false);
  addClose(true);

  selectResource("SRB Grid Resource");
}

/*
 * Takes an existing query from the submission and 
 * re-constructs it on the page
 */
function buildFromDef()
{
   if (fieldNamesArray.length > 0) {
     //numConds = fieldNamesArray.length;
     numConds = 0;
     var i;
     for (i=0;i<fieldNamesArray.length;i++) {
       if (fieldNamesArray[i] != "") {
         rowType[i] = 0;
         addField(comparatorArray[i], fieldNamesArray[i], fieldValueArray[i], false);

       } else if (conditionArray[i] != "") {
         rowType[i] = 1;
         addCondition(conditionArray[i], false);

       } else {
         addClose(false);
       }
     }

     numReturns = 0;
     for (i=0;i<returnFieldsArray.length;i++) {
       addReturn(returnFieldsArray[i], false);
     }
     return true;
   }
   return false;
}

/*
 * Will build an existing query or initialize the query builder 
 * with an empty "AND" condition
 */
function init(qTitle, qNameSpace, qNSPrefix, url)
{
  checkVersion(); 

  title            = qTitle     == null ? "" : qTitle;
  namespace        = qNameSpace == null ? "" : qNameSpace;
  namespace_prefix = qNSPrefix  == null ? "" : qNSPrefix;
  gUrl             = url        == null ? gUrl : url;


  var didBuild = buildFromDef();
  if (!didBuild) {
    //alert("We will initialize the query builder with a simple 'AND' condition\nand add one return field for you.");
    addCondition("AND", false);
      addField("LIKE", "", "", false);
      addField("LIKE", "", "", false);
    addClose(false);
    addReturn("", false);
  }

  createForm();

}

/*
 * Capture all the values out of the UI and put it into the arrays
 */
function clearCurrentValues()
{

  //title            = getTextControlValue('title', title);
  //namespace        = getTextControlValue('namespace', namespace);
  //namespace_prefix = getTextControlValue('namespace_prefix', namespace_prefix);

  // Capture current values before adding next row
  var i;
  for (i=0;i<numConds;i++) {
    lastType = rowType[i];
    if (rowType[i] == 0 && document.getElementById('fieldNames_'+ i) != null) {
      document.getElementById('fieldNames_'+ i).value = "";
      document.getElementById('fieldValues_'+ i).value = "";
    }
  }

  for (i=0;i<numReturns;i++) {
    var fieldCtrl = document.getElementById('returnFields_'+ i);
    if (fieldCtrl != null) {
      fieldCtrl.value = "";
    }
  }
}

// -->
