/**
 *  '$RCSfile: TestMetacatQuery.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *  Purpose: To test the MetaCatURL class by JUnit
 *    Authors: @Rod SPears@
 *    Release: @release@
 *
 *   '$Author: rspears $'
 *     '$Date: 2004-07-26 22:59:38 $'
 * '$Revision: 1.3 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

import edu.ucsb.nceas.metacat.MetaCatUtil;
//import edu.ucsb.nceas.metacat.*;
import edu.ucsb.nceas.utilities.HttpMessage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

import java.io.*;
import java.net.*;
import java.util.*;

import org.ecoinformatics.ecogrid.EcogridResultsetTransformer;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.EcogridQueryParser;
import org.ecoinformatics.ecogrid.metacat.impl.EcogridJavaToMetacatJavaQueryTransformer;
import org.ecoinformatics.ecogrid.QueryType;
import org.ecoinformatics.ecogrid.ResultsetType;

import org.ecoinformatics.ecogrid.metacat.impl.MetacatImpl;

/**
 * A JUnit test for testing Step class processing
 */
public class TestMetacatQuery extends TestCase
{
  private boolean     _doTests   = @DO.QUERY.TESTS@;
  private MetacatImpl _proxyImpl = null;

  /**************************************************************************
   ** Reads a ecogrid query, transforms it into a metacat query
   *************************************************************************/
  public boolean checkMetacatQuery(String aFileName) {

    boolean status = false;

    if (_proxyImpl == null) {
        _proxyImpl = new MetacatImpl();
    }

    try
    {
      QueryType query = EcogridUtils.readEcogridXMLQuery(aFileName);

      ResultsetType results = _proxyImpl.query(query);

      //String metacatQuery = _proxyImpl.getMetacatQuery();

      MetaCatUtil.debugMessage("===================================================", 30);
      if (results != null)
      {
        String resultsStr = EcogridResultsetTransformer.toXMLString(results);
        MetaCatUtil.debugMessage(resultsStr, 30);
      }
      else
      {
        MetaCatUtil.debugMessage("** Resultset was null!", 30);
      }
      MetaCatUtil.debugMessage("===================================================", 30);

    } 
    catch (Exception e) {
      MetaCatUtil.debugMessage("===================================================", 30);
      MetaCatUtil.debugMessage("Failed in checkMetacatQuery", 30);
      MetaCatUtil.debugMessage(e.toString(), 30);
      e.printStackTrace();
      MetaCatUtil.debugMessage("===================================================", 30);
      status = false;
    }
    return status;
  }

  
  /** Creates a new instance of MetacatQueryResults and runs the tests */
  public void testEcogridMetacatEngine() {
      
    if(_doTests)
    {
      assertTrue(checkMetacatQuery("testfiles/query-test.xml"));
    }

  }

}
