/**
 *  '$RCSfile: IdentifierServiceClientTest.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-10-31 17:48:27 $'
 * '$Revision: 1.3 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ecoinformatics.ecogrid.client;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * A JUnit test for testing the indexing routines for XML Paths
 */
public class IdentifierServiceClientTest extends TestCase {

	// LSID must be of the form:
	// urn:lsid:<AuthorityID>:<NamespaceID>:<ObjectID>:[RevisionID]
	private String newLSID = "urn:lsid:localhost:tao:1:1";
	private String validLSID = "urn:lsid:localhost:tao:1:1";
	private String partialLSID = "localhost:tao";
	//private String endpoint = "http://dev.nceas.ucsb.edu/knb/services/IdentifierService";
	private String endpoint = "http://dev.nceas.ucsb.edu/knb/services/IdentifierService";

	/**
	 * Constructor to build the test
	 * 
	 * @param name
	 *            the name of the test method
	 */
	public IdentifierServiceClientTest(String name) {
		super(name);
	}

	/**
	 * Establish a testing framework by initializing appropriate objects
	 */
	public void setUp() {

	}

	/**
	 * Release any objects after tests are complete
	 */
	public void tearDown() {
	}

	/**
	 * Create a suite of tests to be run together
	 */
	public static Test suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new IdentifierServiceClientTest("initialize"));
		//suite.addTest(new IdentifierServiceClientTest("addLSID"));
		suite.addTest(new IdentifierServiceClientTest("getAllIds"));
		suite.addTest(new IdentifierServiceClientTest("getNextObject"));
		suite.addTest(new IdentifierServiceClientTest("getNextRevision"));
		suite.addTest(new IdentifierServiceClientTest("isRegistered"));
		return suite;
	}

	/**
	 * Run an initial test that always passes to check that the test harness is
	 * working.
	 */
	public void initialize() {
		assertTrue(1 == 1);
	}

	public void addLSID() {
		String result = null;
		try {
			IdentifierServiceClient client = new IdentifierServiceClient(
					endpoint);
			result = client.addLSID(newLSID);
			System.out.println("result=" + result);
			assertNotNull(result);
		} catch (Exception e) {
			e.printStackTrace();
			fail("problem with method: addLSID");
		}
	}

	public void getAllIds() {
		String result = null;
		try {
			IdentifierServiceClient client = new IdentifierServiceClient(
					endpoint);
			result = client.getAllIds(partialLSID);
			System.out.println("result=" + result);
			assertNotNull(result);

		} catch (Exception e) {
			e.printStackTrace();
			fail("problem with method: getAllIds");
		}
	}

	public void getNextObject() {
		String result = null;
		try {
			IdentifierServiceClient client = new IdentifierServiceClient(
					endpoint);
			result = client.getNextObject(validLSID);
			System.out.println("result=" + result);
			assertNotNull(result);

		} catch (Exception e) {
			e.printStackTrace();
			fail("problem with method: getNextObject");
		}
	}

	public void getNextRevision() {
		String result = null;
		try {
			IdentifierServiceClient client = new IdentifierServiceClient(
					endpoint);
			result = client.getNextRevision(validLSID);
			System.out.println("result=" + result);
			assertNotNull(result);

		} catch (Exception e) {
			e.printStackTrace();
			fail("problem with method: getNextRevision");
		}
	}

	public void isRegistered() {
		boolean result = false;
		try {
			IdentifierServiceClient client = new IdentifierServiceClient(
					endpoint);
			result = client.isRegistered(validLSID);
			System.out.println("result=" + result);
			assertTrue(result);

		} catch (Exception e) {
			e.printStackTrace();
			fail("problem with method: isRegistered");
		}
	}

}
