/** This actor given a contour image of the weather data such as temperature,
 *  pressure etc. overlays the above image on a given San Diego Map.
 *  
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ROADnet;

import java.awt.image.BufferedImage;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ObjectToken;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

//////////////////////////////////////////////////////////////////////////
//// CreateMapImage
/**
   Creates a map image with contour plots representing weather data.
   
   @author Nandita Mangal
   @version $Id: CreateMapImage,v 1.1 2005/09/27 9:32:37 
   category.name orb 
   @category.name external execution
 */

public class CreateMapImage extends TypedAtomicActor {
    /**
     *  @param container The container.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the actor cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the container already has an
     *   actor with this name.
     */
    public CreateMapImage(CompositeEntity container, String name)
	throws NameDuplicationException, IllegalActionException {
	
	super(container, name);

	//port to get the location path of the contour image created.
	input =new TypedIOPort(this,"input",true,false);
	input.setMultiport(false);
	input.setTypeEquals(BaseType.STRING);

	//Map image produced.
	output = new TypedIOPort(this, "output", false, true);
	output.setMultiport(false);
	output.setTypeEquals(BaseType.OBJECT);  


    }

    public void fire()  throws IllegalActionException
    {
	try{

	    //get and specify the locations of the contour and map images.

	    String contourImageFileName = (String) ((StringToken)(input.get(0))).stringValue();
	    String mapImageFileName = "C:/Project/kepler/ROADNetsensors.png";

	    //Image Creator will help in scaling the contour image w.r.t map image as well as overlaying the contour image             on the original San Diego Map.
	    //Tools used in Image Creator : Java2D image manipulation

	    ImageCreator imgCreate = new ImageCreator(contourImageFileName,mapImageFileName);
	    imgCreate.scaleContourImage();
	    BufferedImage mapFinalImage = imgCreate.overlayMapImage();

	    //output the image produced , if required by other future actors.
	    output.broadcast(new ObjectToken(mapFinalImage));
	    
	}catch(Exception e) { System.err.println(e.toString()); }

    }

    //////////////////////////////////////////////////////////////////
    /////                     public Ports                       ////

    /*Gets the location of contour Image produced*/
    public TypedIOPort output;

    /*Outputs the final map Image produced*/
    public TypedIOPort input;

  
   
}
