/** ImageCreator is not an actor but simply a small java helper application
 *  utilized by CreateMapImage in Kepler-ROADNet project for image
 *  manipulation purposes.
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ROADnet;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.File;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

//////////////////////////////////////////////////////////////////////////
//// ImageCreator
/**
   ImageCreator given image locations has features so as to scale,overlay
   and produce sub-images as needed by CreateMapImage actor which tries
   to plot contour plots on a given map.

   @author Nandita Mangal
   @version $Id: ImageCreator.java,v 1.1 2005/09/27 9:46:12 
   @category.name orb
   @category.name external execution
 */
 
public class ImageCreator{
 
    ////////////////////////////////////////////////////////////////////
    /**
     * Create an ImageCreator instance with the contour image location as 
     * well as the map on which contour is supposed to be plotted.
     * @param: contourImageLocation
     * @param: mapImageLocation
     */

    public ImageCreator(String contourFileName,String mapFileName)
    {
	this.contourFileName=contourFileName;
	this.mapFileName=mapFileName;
	
    }

    ////////////////////////////////////////////////////////////////////
    ////                     public methods                         ///

    /**
     * Makes a sub Image of the specific contour plot (created by gnuplot)
     * and then scales it to a a hard coded dimension image.
     */

    public void scaleContourImage()
    {
	
	try{
	    
	    Image contourImage1 = (Toolkit.getDefaultToolkit().getImage(contourFileName));
	    BufferedImage imgBuff = toBufferedImage(contourImage1);

	    //display(imgBuff);
	    //image scaled so as to remove unwanted axis,key information on the plot.
	    imgBuff = imgBuff.getSubimage(150,220,340,180); 
	    
	    //ImageIO.write(imgBuff,"png",new File("C:/Project/kepler/subImageContour.png"));
	    //ImageIO.write(imgBuff,"png",new File("C:/Project/kepler/check1.png"));
	 
	    int width =370;
	    int height=340; 
	    //now we scaled the sub image obtained.
	    Image imgScaled =(Image) ( imgBuff.getScaledInstance(width,height,8));
	    BufferedImage imgScaledBuff = toBufferedImage(imgScaled);
	    contourImage = imgScaledBuff;
	    ImageIO.write(imgScaledBuff,"png",new File("C:/Project/kepler/scaledContour.png"));
	    
   

	}catch(Exception e) { System.err.println(e.toString()+ "in scaling counter image" ); 
	
	};
    }
        
    /**
     * Get the map Image from the specified location and overlays the contourImage.
     * displays the manipulated map image.
     * @return: manipulated map image.
     */

    public BufferedImage overlayMapImage()
    {
	
	try{
	    Image map = (Toolkit.getDefaultToolkit().getImage(mapFileName));
	    map = map.getScaledInstance(900,700,Image.SCALE_REPLICATE);
	    BufferedImage mapBuffered = toBufferedImage(map);
	
	    Graphics2D graphics = mapBuffered.createGraphics();
	    graphics.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.9f));
	    graphics.drawImage(contourImage,387,215, null); //was 475,250
	    graphics.dispose();
	    display(mapBuffered);

	    (new File("C:/Project/kepler/scaledContour.png")).delete();
        
	    return mapBuffered;

	}catch(Exception e) { System.err.println(e.toString()+ "in overlay contour image");}
	
	return null;
    }

    
    
    /**
     * Given a buffered image creates a frame to display that image.
     */

    public static void display(BufferedImage image) {
        JFrame f = new JFrame("Map Image");
      	JLabel label = new JLabel(new ImageIcon(image));
      	
        f.getContentPane().add(label);
        f.pack();
	f.setLocationRelativeTo(null);
        f.setVisible(true);
	f.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
    }
   
    /**
     * Returns a buffered image with the contents of an image
     * @author: The Java Developers Almanac 1.4
     * @return: BufferedImage 
     */

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
	
	
        // This code ensures that all the pixels in the image are loaded
        image = new ImageIcon(image).getImage();
	
        // Determine if the image has transparent pixels; for this method's
        // implementation, see e661 Determining If an Image Has Transparent Pixels
        boolean hasAlpha = hasAlpha(image);
    
        // Create a buffered image with a format that's compatible with the screen
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            // Determine the type of transparency of the new buffered image
            int transparency = Transparency.OPAQUE;

	    if (hasAlpha) {
                transparency = Transparency.BITMASK;
            }
    
            // Create the buffered image
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(
                image.getWidth(null), image.getHeight(null), transparency);
        } catch (HeadlessException e) {
            // The system does not have a screen
        }
    
        if (bimage == null) {
            // Create a buffered image using the default color model
            int type = BufferedImage.TYPE_INT_RGB;
            if (hasAlpha) {
                type = BufferedImage.TYPE_INT_ARGB;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
    
        // Copy image to buffered image
        Graphics g = bimage.createGraphics();
    
        // Paint the image onto the buffered image
        g.drawImage(image, 0, 0, null);
        g.dispose();
    
        return bimage;
    }


    /**
     * This method returns true if the specified image has transparent pixels
     * @author: The Java Developers Almanac 1.4 	
     * @return: boolean if contains transparent pixels or not.
     */

     public static boolean hasAlpha(Image image) {
        // If buffered image, the color model is readily available
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
    
        // Use a pixel grabber to retrieve the image's color model;
        // grabbing a single pixel is usually sufficient
         PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        } catch (InterruptedException e) {
	    //while(true) {System.err.println("checknow");}
        }
    
        // Get the image's color model
        ColorModel cm = pg.getColorModel();
	
        return cm.hasAlpha();
    }

    ////////////////////////////////////////////////////////////////////////////
    ////                       private variables                           ////

    private String contourFileName="";
    private String mapFileName="";

    private BufferedImage contourImage;
}
