/**
 *    '$RCSfile: EcogridMetaDataCacheItem.java,v $'
 *
 *     '$Author: ruland $'
 *       '$Date: 2006/01/24 19:47:19 $'
 *   '$Revision: 1.14 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.ecoinformatics.seek.datasource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * @author globus
 *
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class EcogridMetaDataCacheItem extends EcogridDataCacheItem 
{
	  private static Log log;
	  static {
		  log = LogFactory.getLog("org.ecoinformatics.seek.datasource.EcogridMetaDataCacheItem");
	  }

    protected String mRecordId = null;
    
    /**
     * 
     *
     */
    public EcogridMetaDataCacheItem()
    {
        super();
    }
    
    /* (non-Javadoc)
     * @see org.ecoinformatics.seek.datasource.DataCacheItem#doWork()
     */
    public int doWork()
    {
        log.debug("EcogridMetaDataCacheItem - doing Work mStatus "+getStatus());
        return getDataItemFromEcoGrid(mEndPoint, mRecordId);
    }
    
    /**
     * @return Returns the mRecordId.
     */
    public String getRecordId()
    {
        return mRecordId;
    }
    
    /**
     * @param recordId The mRecordId to set.
     */
    public void setRecordId(String recordId)
    {
        mRecordId = recordId;
    }
}
