package org.ecoinformatics.seek.datasource.eml.eml2;

class Eml200DataOutputFormatFactory {
	static final String _AsField = "As Field";
	static final String _AsTable = "As Table";
	static final String _AsRow = "As Row";
	static final String _AsByteArray = "As Byte Array";
	static final String _AsUnzippedFileName = "As UnCompressed File Name";
	static final String _AsFileName = "As Cache File Name";
	static final String _AsColumnVector  = "As Column Vector";
	static final String _AsColumnRecord = "As ColumnBased Record";

	private Eml200DataOutputFormatFactory()
	{}
	
	static Eml200DataOutputFormatBase newInstance( String dataOutputFormat, Eml200DataSource that )
	{
		if ( _AsTable.equals(dataOutputFormat)) {
			return new Eml200DataOutputFormatTable(that);
		}
		if (_AsRow.equals(dataOutputFormat)) {
			return new Eml200DataOutputFormatRow(that);
		}
		if (_AsField.equals(dataOutputFormat)) {
			return new Eml200DataOutputFormatField(that);
		} 
		if (_AsByteArray.equals(dataOutputFormat)) {
			return new Eml200DataOutputFormatByteArray(that);
		}
		if (_AsUnzippedFileName.equals(dataOutputFormat) ) {
			return new Eml200DataOutputFormatUnzippedFileName(that);
		} 
		if (_AsFileName.equals(dataOutputFormat)) {
			return new Eml200DataOutputFormatFileName(that);
		} 
		if (_AsColumnVector.equals(dataOutputFormat)) {
			return new Eml200DataOutputFormatColumnVector(that);
		} 	
		if (_AsColumnRecord.equals(dataOutputFormat)) {
		return new Eml200DataOutputFormatColumnRecord(that);
		}
		return new Eml200DataOutputFormatField(that);
	}
	
	static Eml200DataOutputFormatBase newInstance(Eml200DataSource that )
	{
		return new Eml200DataOutputFormatInitialize(that);
	}
}
