/**
 *    '$RCSfile: SearchRegistryAction.java,v $'
 *
 *     '$Author: ruland $'
 *       '$Date: 2006/01/05 14:42:41 $'
 *   '$Revision: 1.18 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.ecogrid;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Vector;

import javax.swing.AbstractAction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.ecogrid.client.EcogridRegistryClient;
import org.ecoinformatics.ecogrid.registry.stub.EcogridRegEntryType;
import org.ecoinformatics.ecogrid.registry.stub.EcogridRegEntryTypeDocumentType;
import org.ecoinformatics.util.Config;


/**
 * Class will search the registry
 * @author Jing Tao
 *  
 */

public class SearchRegistryAction extends AbstractAction 
{
  private RegistrySearchDialog searchDialog        = null;
  private ServicesDisplayFrame parent              = null;
  private String registryEndPoint                  = null;
  private Point location                           = null;
  private EcogridRegistryClient client      = null;
  
  private static final String ENDPOINTPATH         = "//ecogridService/registry/endPoint";
  private static final String PERCENTAGE           = "%";
  private String sessionId = "foo"; // this value can be replaced by something else

  protected final static Log log;
  static {
  	log = LogFactory.getLog( "org.ecoinformatics.seek.ecogrid.SearchRegistryAction" );
  }

  /**
   * Constructor
   * @param name String
   * @param searchDialog JDialog
   * @param parent ServicesDisplayFrame
   */
  public SearchRegistryAction(String name, RegistrySearchDialog searchDialog, 
                              ServicesDisplayFrame parent, Point location) 
  {
    super(name);
    this.searchDialog = searchDialog;
    this.parent       = parent;
    this.location     = location;
    registryEndPoint  = Config.getValue(ENDPOINTPATH);
  
   
  }//SearchRegistryAction
  
  /**
   * Method do search
   * @param e ActionEvent
   */
  public void actionPerformed(ActionEvent e) 
  {
    String xpath = searchDialog.getXPath();
    String value = searchDialog.getSearchValue();
    try
    {
       client  = new EcogridRegistryClient(registryEndPoint);
    }
    catch (Exception ee)
    {
       log.debug("The error to generate registry search client ", ee );
    }
    if (client != null && xpath != null && !xpath.trim().equals(""))
    {
      Vector searchResult = searchRegistry(xpath, value);
      Vector selectedServicesLists    = 
      SelectableEcoGridService.transferServiceVectToDefaultSelectedServiceVect(searchResult); 
      // destroy the search dialog
      searchDialog.setVisible(false);
      searchDialog.dispose();
      searchDialog = null;
      // create a search result frame base on search result
      EcoGridServicesController controller = parent.getEcoGridServicesController();
      SearchRegistryResultFrame resultFrame = new SearchRegistryResultFrame("Search Result", 
                                        selectedServicesLists, controller,parent, location); 
     
    }//if
   
  }//actionPerformed
  
  
  /*
   * This methd will search registry
   */
  private Vector searchRegistry(String optionLabel, String value)
  {
    Vector newServiceList = new Vector();
    //newServiceList = hardCodeReturnVector();
    //This is for all service
    if (optionLabel != null && optionLabel.equals(RegistrySearchDialog.ALLSERVICES))
    {
      log.debug("The option label is " +optionLabel);
      EcogridRegEntryType[] serviceList = null;
      try
      {
        serviceList = client.gelAllRegistryEntries(sessionId);  
        newServiceList = transferRegEntriesArrayToVector(serviceList);
      }
      catch(Exception e)
      {
        log.debug("couldn't search the ecogrid registry because ", e);
      }
      
    }//if
    else if (optionLabel != null && value != null)
    {
      log.debug("The option label is " +optionLabel + " and value is " +value);
      String xpath = searchDialog.getXPath(optionLabel);
      value = decrorateSearchValeu(value);
      log.debug("The xpath value is " + xpath + " for option label "+
                optionLabel);
      if (xpath != null)
      {
        EcogridRegEntryType[] serviceList = null;
        try 
        {
          serviceList = client.queryRegistry(sessionId, xpath, value);
          newServiceList = transferRegEntriesArrayToVector(serviceList);
        }
        catch (Exception e) 
        {
          log.debug("couldn't search the ecogrid registry because ", e);
        }
      }//if

    }//elseif
    
    return newServiceList;
  }//searchResigry
  
  
  private Vector transferRegEntriesArrayToVector(EcogridRegEntryType[] list)
  {
    Vector serviceVector = new Vector();
    if (list == null)
    {
      log.debug("The reg list is null for regsitry");
      return serviceVector;
    }
    int length = list.length;
    for (int i=0; i<length; i++)
    {
      EcogridRegEntryType registryType = list[i];
      String serviceName = registryType.getServiceName();
      log.debug("The service name from registry is "+serviceName);
      String serviceType = registryType.getServiceType();
      log.debug("The service type from registry is "+serviceType);
      String endpoint    = registryType.getEndPoint();
      log.debug("Find the service " + endpoint +" in registry");
      EcogridRegEntryTypeDocumentType[] typeList = registryType.getDocumentType();
        
      DocumentType[] docTypeList = null;
      EcoGridService service = new EcoGridService();
      service.setServiceName(serviceName);
      try
      {
        service.setServiceType(serviceType);
        service.setEndPoint(endpoint);
        docTypeList = transferRegDocTypeArray(typeList);
        if (docTypeList == null || docTypeList.length == 0)
        {
          log.debug("Document type is null and we wouldn't display the service  ");
          continue; 
        }
      }
      catch(Exception e)
      {
        log.debug("Could not set service  "+e.getMessage());
        continue;
      }
      service.setDocumentTypeList(docTypeList);
      log.debug("Add service "+ endpoint + " into the vector");
      serviceVector.add(service);
    }//
    return serviceVector;
  }//transferRegEntriesArrayToVector
  
  private DocumentType[] transferRegDocTypeArray(EcogridRegEntryTypeDocumentType[] regTypeList) throws Exception
  {
    DocumentType[] docTypeList = null;
    if (regTypeList == null)
    {
      return docTypeList;
    }//if
    int length = regTypeList.length;
    Vector tmp = new Vector();
    for (int i=0; i<length; i++)
    {
      EcogridRegEntryTypeDocumentType regDocType = regTypeList[i];
      String namespace = regDocType.getNamespace();
      String label     = regDocType.getLabel();
      try
      {
        DocumentType type = new DocumentType(namespace, label);
        tmp.add(type);
      }
      catch(Exception e)
      {
        log.debug("Could not create document type ", e);
        throw e;
      }
    }//for
     //transfer the tmp vector to an array
     int size = tmp.size();
     docTypeList = new DocumentType[size];
     for (int i = 0; i<size; i++)
     {
       docTypeList[i] = (DocumentType)tmp.elementAt(i);
     }//for
     return docTypeList;
  }//transferRegDocTypeArray
  
  /*
   * Method to add % symbol to value
   */
  private String decrorateSearchValeu(String value)
  {
    String newValue = PERCENTAGE+value+PERCENTAGE;
    return newValue;
  }
  
  /*
   * This method is hard code to go some serivce list without searching
   */
  private Vector hardCodeReturnVector()
  {
    Vector newServiceList = new Vector();
    try 
    {
      DocumentType type1 = new DocumentType(
          "eml://ecoinformatics.org/eml-2.0.0",
          "Ecological Metadata Language 2.0.0");
      DocumentType type2 = new DocumentType(
          "http://digir.net/schema/conceptual/darwin/full/2001/1.0",
          "Darwin Core 1.0");
      DocumentType[] docTypes = new DocumentType[2];
      docTypes[0] = type1;
      docTypes[1] = type2;
      EcoGridService service1 = new EcoGridService();
      service1.setServiceName("KNB EcoGrid");
      service1.setServiceType("EcoGridQueryInterface");
      service1.setEndPoint("http://ecogrid.ecoinformatics.org/ogsa/services/org/ecoinformatics/ecogrid/EcoGridQueryInterfaceLevelOneService");
      service1.setDocumentTypeList(docTypes);

      DocumentType type3 = new DocumentType(
          "eml://ecoinformatics.org/eml-2.0.0",
          "Ecological Metadata Language 2.0.0");
      DocumentType type4 = new DocumentType(
          "http://digir.net/schema/conceptual/darwin/full/2001/1.0",
          "Darwin Core 1.0");
      DocumentType[] docTypes1 = new DocumentType[2];
      docTypes1[0] = type3;
      docTypes1[1] = type4;
      EcoGridService service2 = new EcoGridService();
      service2.setServiceName("KU Digir EcoGrid QueryInterface");
      service2.setServiceType("EcoGridQueryInterface");
      //service2.setEndPoint("http://129.237.201.166:8080/ogsa/services/org/ecoinformatics/ecogrid/EcoGridQueryInterfaceLevelOneServiceFactory");
      service2.setEndPoint("http://129.237.127.19:8080/ogsa/services/org/ecoinformatics/ecogrid/EcoGridQueryInterfaceLevelOneService");
      service2.setDocumentTypeList(docTypes1);

      DocumentType type5 = new DocumentType(
          "eml://ecoinformatics.org/eml-2.0.0",
          "Ecological Metadata Language 2.0.0");
      DocumentType type6 = new DocumentType(
          "http://digir.net/schema/conceptual/darwin/full/2001/1.0",
          "Darwin Core 1.0");
      DocumentType[] docTypes2 = new DocumentType[2];
      docTypes2[0] = type5;
      docTypes2[1] = type6;
      EcoGridService service3 = new EcoGridService();
      service3.setServiceName("Pine EcoGrid QueryInterface");
      service3.setServiceType("EcoGridQueryInterface");
      service3.setEndPoint("http://pine.nceas.ucsb.edu:8090/ogsa/services/org/ecoinformatics/ecogrid/EcoGridQueryInterfaceLevelOneService");
      service3.setDocumentTypeList(docTypes2);

      newServiceList.add(service1);
      newServiceList.add(service2);
      newServiceList.add(service3);

    }
    catch (Exception e) 
    {

    }
   return newServiceList;
  }
  
  
}//SearchRegistryAction
