/**
 *    '$RCSfile: ServicesListModificationFrame.java,v $'
 *
 *     '$Author: ruland $'
 *       '$Date: 2005/11/01 20:39:05 $'
 *   '$Revision: 1.14 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.ecogrid;

import java.awt.BorderLayout;
import java.awt.Point;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;


/**
 * This class represents a frame for service list modification
 * @author Jing Tao
 */

public class ServicesListModificationFrame extends ServicesDisplayFrame 
{
  //private JButton removeButton  = null;
  private JButton addButton     = null;
  private JButton okButton      = null;
  private JButton cancelButton  = null;
  private JPanel newButtonPanel = null;
  
  private static final String TEXT ="Current Data Source(s):";  
  /**
   * Constructor for the frame
   * @param frameTitle String
   * @param selectedServiceList Vector
   */
  public ServicesListModificationFrame(String frameTitle, 
                      EcoGridServicesController controller, Point location) 
  {
    super(frameTitle, controller.getServicesList(), controller, location);
    setDisplayText(TEXT);
    initButtonPanel();
    // set remove button as reponse button when user click check box
    //getServicesDisplayPanel().setResponseButton(removeButton);
  }//ServicesListModificationFrame
  
  /*
   * This method will init button panel
   */
  private void initButtonPanel()
  {
    /*removeButton = new JButton(new RemoveServiceAction("Remove", this));
    removeButton.setPreferredSize(ServicesDisplayFrame.BUTTONDIMENSION);
    removeButton.setMaximumSize(ServicesDisplayFrame.BUTTONDIMENSION);
    removeButton.setEnabled(false);*/
    addButton    = new JButton(new InitialRegistrySearchDialogAction("Add", this, 
                                                super.getOriginalServiceList()));
    addButton.setPreferredSize(ServicesDisplayFrame.BUTTONDIMENSION);
    addButton.setMaximumSize(ServicesDisplayFrame.BUTTONDIMENSION);
    addButton.setSize(ServicesDisplayFrame.BUTTONDIMENSION);
    okButton     = new JButton(new OkServiceModificationAction("Ok", this));
    okButton.setPreferredSize(ServicesDisplayFrame.BUTTONDIMENSION);
    okButton.setMaximumSize(ServicesDisplayFrame.BUTTONDIMENSION);
    cancelButton = new JButton(new CancelServiceModificationAction("Cancel", this, 
                                      controller, super.getOriginalServiceList()));
    cancelButton.setPreferredSize(ServicesDisplayFrame.BUTTONDIMENSION);
    cancelButton.setMaximumSize(ServicesDisplayFrame.BUTTONDIMENSION);
    JPanel bottomPanel = new JPanel();
    bottomPanel.setLayout(new BorderLayout());
    JPanel rightPart = new JPanel();
    rightPart.setLayout(new BoxLayout(rightPart, BoxLayout.X_AXIS));
    //rightPart.add(removeButton);
    //rightPart.add(Box.createHorizontalStrut(ServicesDisplayFrame.MARGINGSIZE));
    rightPart.add(addButton);
    JPanel leftPart = new JPanel();
    leftPart.setLayout(new BoxLayout(leftPart, BoxLayout.X_AXIS));
    leftPart.add(okButton);
    leftPart.add(Box.createHorizontalStrut(ServicesDisplayFrame.MARGINGSIZE));
    leftPart.add(cancelButton);
    bottomPanel.add(rightPart, BorderLayout.WEST);
    bottomPanel.add(leftPart, BorderLayout.EAST);
    newButtonPanel = new JPanel();
    newButtonPanel.setLayout(new BorderLayout());
    newButtonPanel.add(Box.createVerticalStrut(ServicesDisplayFrame.MARGINGSIZE), 
                                               BorderLayout.NORTH);
    newButtonPanel.add(bottomPanel, BorderLayout.SOUTH);
    setButtonPanel(newButtonPanel);
  }//initButton
  
  /**
   * This method will re-add buttons to frame
   */
  public void updateButtonPanel()
  {
    this.remove(newButtonPanel);
    initButtonPanel();
    // don't forget to add remove button as reponse button(enable and disable)
    // as check box listener
    //getServicesDisplayPanel().setResponseButton(removeButton);
  }//updateButtonPanel
  
  
  public static void main(String[] args)
  {

   EcoGridQueryServicesController controller = EcoGridQueryServicesController.getInstance();
   Vector unSelectedserviceList = controller.getServicesList();
   //transfer to selectedSerive list(object is SelectedEcoGridService now)
   

   ServicesListModificationFrame frame = new ServicesListModificationFrame("SwingApplication", 
                                                                            null, null);

  }//main
  

}//ServicesListModificationFrame