/* The node controller for actor instances.

 Copyright (c) 2003-2004 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */
package org.ecoinformatics.seek.ecogrid.quicksearch;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Reader;
import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.util.Util;

import ptolemy.actor.gui.Configuration;
import ptolemy.vergil.basic.BasicGraphFrame;
import ptolemy.vergil.toolbox.FigureAction;
//import ptolemy.kernel.util.Configurable;
/**
 * This is an action to get metadata for search result item in data search result
 * panel
 * @author Jing Tao
 */
public class GetMetadataAction extends FigureAction 
{
    private Reader metadataSource = null;
    private String nameSpace      = null;
    private String htmlFileName   = null;
    private URL    metadata       = null;
    private ResultRecord item     = null;
    private Configuration configuration = null;
    private ResultPanel   panel         = null;
    private static final String LABEL = "GetMetadata";
    
    protected final static Log log;
    static {
    	log = LogFactory.getLog( "org.ecoinformatics.seek.ecogrid.GetMetadataAction" );
    }
 
  
    /**
     * Constructor base a given ResultRecord object
     * @param item ResultRecord
     */
    public GetMetadataAction(ResultRecord item, ResultPanel panel)
    {
        super(LABEL);
        this.item = item;
        this.panel = panel;
       
    }
    
    /**
     * Method to get the metadata(the generated html file 
     * after transfering original metadata)
     * @return URL
     */
    public URL getMetadata()
    {
        return metadata;
    }

    /**
     * Invoked when an action occurs. It will transfer the original metadata into
     * a html file. The namespace will be the key to find stylesheet. If no
     * sytlesheet found, metadata will be null.
     *
     * @param e ActionEvent
     */
    public void actionPerformed(ActionEvent e) 
    {
        
        super.actionPerformed(e);
        if (this.item != null)
        {
            this.metadataSource = item.getFullRecord();
            this.nameSpace = item.getNamespace();
            this.htmlFileName = item.getRecordId();
        }
        if (configuration == null)
        {
            configuration = getConfiguration();
        }
        if (metadataSource != null && nameSpace != null && 
            htmlFileName != null && configuration != null)
        {
           
           
            try 
            {
                metadata =
                        Util.getMetadataHTMLurl(metadataSource, nameSpace,
                                                htmlFileName);
                System.out.println("before open html page");
                configuration.openModel(null, metadata, metadata.toExternalForm());
                System.out.println("after open html page");

            } 
            catch (Exception ee) 
            {
                log.debug("The error to get metadata html ", ee);
            }
        
            
        }           
    }
    
      /*
     * Method to get Configuration object in the top level container
     */
    private Configuration getConfiguration()
    {
        Configuration config = null;
        Component current = panel;
        Component parent  = panel;
        while (parent != null && !(parent instanceof BasicGraphFrame))
        {
            
            parent = current.getParent();
            current = parent;
        }
        BasicGraphFrame frame = (BasicGraphFrame)parent;
        config = frame.getConfiguration();
        return config;
    }
}