/**
 *    '$RCSfile: DBDisplayItemIFace.java,v $'
 *
 *     '$Author: zhu $'
 *       '$Date: 2005/07/19 08:27:00 $'
 *   '$Revision: 1.2 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.ecoinformatics.seek.querybuilder;

import org.kepler.objectmanager.data.db.DSTableFieldIFace;

/**
 * This interface is implemented by classes that are "fields" to be displayed
 *
 */
public interface DBDisplayItemIFace extends DSTableFieldIFace
{
  /**
   * Returns name of the table that the field belongs to
   * @return string of the name
   */
  public String getTableName();

  /**
   * Return whether it is being displayed
   * @return true if the display attr is set
   */
  public boolean isDisplayed();

  /**
   * Set whether it is displayed or not
   * @param aIsDisplayed true if the display attr is to be set
   */
  public void setDisplayed(boolean aIsDisplayed);

}
