/**
 *    '$RCSfile: TypedIOPortObject.java,v $'
 *
 *     '$Author: jones $'
 *       '$Date: 2003/12/18 08:35:26 $'
 *   '$Revision: 1.2 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.workflow;

/**
 * an object to pass TypedIOPort information around
 */
public class TypedIOPortObject
{
  private String name;
  private TypeObject type;
  private boolean isInput;
  private boolean isOutput;

  /**
   * Constructor
   * @param name
   * @param isInput
   * @param isOutput
   */
  public TypedIOPortObject(String name, TypeObject type, boolean isInput,
    boolean isOutput)
  {
    this.name = name;
    this.type = type;
    this.isInput = isInput;
    this.isOutput = isOutput;
  }

  /**
   * returns the string declaration of the port in the form
   * TypedIOPort(this, "input1", true, false)
   */
  public String getConstructorDeclaration()
  {
    return "TypedIOPort(this, \"" + name + "\", " + isInput + ", " +
      isOutput + ")";
  }

  /**
   * returns the type declaration which is of the form
   * BaseType.&lt;TypeName&gt;[_MATRIX]
   */
  public String getTypeDeclaration()
  {
    return type.getTypeDeclaration();
  }

  /**
   * return a string rep of this object for the list boxes
   */
  public String toString()
  {
    return name + " - " + type.getType() + " (" + type.getTypeDimension() + ")";
  }

  ////////////////////Accessor Methods///////////////////////////
  public String getName()
  {
    return name;
  }

  public TypeObject getType()
  {
    return type;
  }

  public boolean getIsInput()
  {
    return isInput;
  }

  public boolean getIsOutput()
  {
    return isOutput;
  }

  public void setName(String name)
  {
    this.name = name;
  }

  public void setType(TypeObject type)
  {
    this.type = type;
  }

  public void setIsInput(boolean isInput)
  {
    this.isInput = isInput;
  }

  public void setIsOutput(boolean isOutput)
  {
    this.isOutput = isOutput;
  }
}
