/**
 *  '$RCSfile: AnnotatedPTree.java,v $' 
 *  '$Author: berkley $' 
 *  '$Date: 2006/01/20 21:16:23 $' 
 *  '$Revision: 1.12 $' 
 * 
 *  For Details:
 *  http://kepler.ecoinformatics.org 
 * 
 *  Copyright (c) 2004 The Regents of the
 *  University of California. All rights reserved. Permission is hereby granted,
 *  without written agreement and without license or royalty fees, to use, copy,
 *  modify, and distribute this software and its documentation for any purpose,
 *  provided that the above copyright notice and the following two paragraphs
 *  appear in all copies of this software. IN NO EVENT SHALL THE UNIVERSITY OF
 *  CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL,
 *  OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS
 *  DOCUMENTATION, EVEN IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY
 *  DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 *  SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 *  CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 *  ENHANCEMENTS, OR MODIFICATIONS.
 */
 
package org.kepler.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

import org.ecoinformatics.seek.sms.OntologyCatalog;
import org.kepler.ksw.gui.CreateKSWDialog;

import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.vergil.tree.PTree;

/**
 *  A Wrapper class that adds right click support to a PTree
 *
 *@author     Chad Berkley
 *@created    February 17, 2005
 *@version    $Id: AnnotatedPTree.java,v 1.12 2006/01/20 21:16:23 berkley Exp $
 *@since      Kepler 1.0
 */
public class AnnotatedPTree extends PTree
{
  private JPopupMenu popup;
  private java.awt.Component parent;
  private Vector listeners;
  
  /**
   * Constructor
   * @param model the model to build the tree out of
   */
  public AnnotatedPTree(javax.swing.tree.TreeModel model, 
    java.awt.Component parent)
  {
    super(model);
    MouseListener popupListener = new PopupListener();
    this.addMouseListener(popupListener);
    this.parent = parent;
    listeners = new Vector();
  }
  
  /**
   * add a listener for events
   */
  public void addListener(ActionListener listener)
  {
    listeners.addElement(listener);
  }
  
  /**
   * notify this tree that the mouse is dragging an object over the x,y position
   */
  public void notifyDragOver(int x, int y)
  {
    TreePath location = this.getClosestPathForLocation(x, y);
    this.clearSelection();
    this.setSelectionPath(location);
  }
  
  /**
   * notify this tree that the mouse is dragging an object over the x,y position
   */
  public void notifyComponentDrop(int x, int y, Object component, 
    CompositeEntity actorLibrary)
  {   
    java.awt.Component parent = this.getParent();
    while(!(parent instanceof java.awt.Frame))
    {
      parent = parent.getParent();
    }
    
    String conceptLabel = ((CompositeEntity) getSelectionPath()
      .getLastPathComponent()).getName();
    OntologyCatalog catalog = OntologyCatalog.instance();
    String conceptName = catalog.getConceptNameWithLabel(conceptLabel);
    
    CreateKSWDialog dialog = new CreateKSWDialog((java.awt.Frame)parent, 
      (Entity)component, actorLibrary, conceptName);
    dialog.setVisible(true);
  }
  
  /**
   * notify all listeners of events
   */
  private void notifyListeners(ActionEvent event)
  {
    for(int i=0; i<listeners.size(); i++)
    {
      ActionListener listener = (ActionListener)listeners.elementAt(i);
      listener.actionPerformed(event);
    }
  }
  
  /**
   *  Add a listener for a right click menu in the PTree
   *
   *@author     berkley
   *@created    February 17, 2005
   */
  class PopupListener extends MouseAdapter
  {
    // on the Mac, popups are triggered on mouse pressed, while
    // mouseReleased triggers them on the PC; use the trigger flag to
    // record a trigger, but do not show popup until the
    // mouse released event
    boolean trigger = false;

    /**
     *  Description of the Method
     *
     *@param  e  Description of the Parameter
     */
    public void mousePressed(MouseEvent e)
    {
      if (e.isPopupTrigger())
      {
        trigger = true;
      }
    }

    /**
     *  Description of the Method
     *
     *@param  e  Description of the Parameter
     */
    public void mouseReleased(MouseEvent e)
    {
      maybeShowPopup(e);
    }

    /**
     *  Description of the Method
     *
     *@param  e  Description of the Parameter
     */
    private void maybeShowPopup(MouseEvent e)
    {
      if (e.isPopupTrigger() || trigger)
      {
        /*&trigger = false;
        TreePath selPath = getPathForLocation(e.getX(), e.getY());
        if ((selPath != null))
        {
          Object ob = selPath.getLastPathComponent();
          if(ob instanceof ptolemy.moml.EntityLibrary)
          { //show this popup if we are clicking on a folder
            ActionHandler handler = new ActionHandler();
            AddFolderAction addFolderAction = new AddFolderAction(selPath, parent);
            addFolderAction.addListener(handler);
            AddActorAction addActorAction = new AddActorAction(selPath, parent);
            addActorAction.addListener(handler);
            
            popup = new JPopupMenu();
            popup.add(new JMenuItem(addFolderAction));
            popup.add(new JMenuItem(addActorAction));
            setSelectionPath(selPath);
            popup.show(e.getComponent(), e.getX(), e.getY());
          }
          else if(ob instanceof ptolemy.actor.AtomicActor)
          { //show this popup if we are clicking on an actor
            RemoveActorAction removeActorAction = 
              new RemoveActorAction(selPath, parent);
            CreateKSWFromActorAction createKSWAction = 
              new CreateKSWFromActorAction(selPath, parent);
            popup = new JPopupMenu();
            popup.add(new JMenuItem(removeActorAction));
            popup.add(new JMenuItem(createKSWAction));
            setSelectionPath(selPath);
            popup.show(e.getComponent(), e.getX(), e.getY());
          }
        }*/
      }
    }
  }
    
  /**
   * Listener used to changes from the NewFolderFrame
   */
  private class ActionHandler implements ActionListener
  {
    /**
     *  Description of the Method
     *
     * @param  event  Description of Parameter
     */
    public void actionPerformed(ActionEvent event)
    {
      String command = event.getActionCommand();
      if(command.equals("new_folder_created") || 
         command.equals("new_actor_created"))
      {
        //notify the TabbedLibraryPane that a changeRequest needs to be filed
        notifyListeners(event);
      }
    }
  }
}
