package org.kepler.gui;

import java.net.URL;

import org.ecoinformatics.util.Config;
import ptolemy.vergil.VergilApplication;

public class KeplerApplication {

    /** Create a new instance of this application, passing it the
     *  command-line arguments.
     *  @param args The command-line arguments.
     */
    public static void main(final String[] args) {
        SplashScreen s = null;
        WelcomeScreen w = null;

        try {
            Config c = Config.getInstance();

            /*
             * At some time, this will be the splash. But right now it's not working.
             */
            String splashname = c.getValue("//splash/image");

            URL splash = ClassLoader.getSystemClassLoader().getResource(splashname);;
            String splashto = c.getValue("//splash/timeout");

            int splashtimeout = Integer.parseInt(splashto);

            if ( splash != null ) {
                s = new SplashScreen(splash,splashtimeout);
            }
            new VergilApplication(args);

            
    }
        catch(Exception e) {
            System.err.println("Unable to start application");
            e.printStackTrace();
        }
        finally {
            if ( s != null ) {
                s.dismiss();
            }
        }
    }
}
