/*
 *  An object that can create a tableau for a model.
 *  Copyright (c) 1997-2003 The Regents of the University of California.
 *  All rights reserved.
 *  Permission is hereby granted, without written agreement and without
 *  license or royalty fees, to use, copy, modify, and distribute this
 *  software and its documentation for any purpose, provided that the above
 *  copyright notice and the following two paragraphs appear in all copies
 *  of this software.
 *  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 *  FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 *  THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 *  PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 *  CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 *  ENHANCEMENTS, OR MODIFICATIONS.
 *  PT_COPYRIGHT_VERSION_2
 *  COPYRIGHTENDKEY
 *  @ProposedRating Green (eal@eecs.berkeley.edu)
 *  @AcceptedRating Yellow (celaine@eecs.berkeley.edu)
 */
package org.kepler.gui;

import java.awt.event.ActionListener;
import java.util.Iterator;

import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

/**
 *  This class creates a gui pane that allows the users to search the actor
 *  library.
 *
 *@author     Chad Berkley
 *@created    February 17, 2005
 *@version    $Id: LibrarySearchGUIPaneFactory.java,v 1.1 2004/09/08 19:09:21
 *      berkley Exp $
 *@since      Kepler 1.0 alpha 2
 */
public class LibrarySearchGUIPaneFactory extends Attribute
{

  /**
   *  Create a factory with the given name and container.
   *
   *@param  container                     The container.
   *@param  name                          The name.
   *@exception  IllegalActionException    If the container is incompatible with
   *      this attribute.
   *@exception  NameDuplicationException  If the name coincides with an
   *      attribute already in the container.
   */
  public LibrarySearchGUIPaneFactory(NamedObj container, String name)
    throws IllegalActionException, NameDuplicationException
  {
    super(container, name);
  }


  ///////////////////////////////////////////////////////////////////
  ////                         public methods                    ////

  /**
   *  This method returns a LibrarySearchPane for use in the plugable interface.
   *
   *@param  searchButtonHandler
   *@return                      A tableau for the effigy, or null if one cannot
   *      be created.
   */
  public LibrarySearchPane createLibrarySearchGUIPane(
      ActionListener searchButtonHandler)
  {
    LibrarySearchPane searchpane = null;
    Iterator factories = attributeList(
        LibrarySearchGUIPaneFactory.class).iterator();
    while (factories.hasNext() && searchpane == null)
    {
      LibrarySearchGUIPaneFactory factory =
          (LibrarySearchGUIPaneFactory) factories.next();
      searchpane = factory.createLibrarySearchGUIPane(searchButtonHandler);
    }
    return searchpane;
  }
}

