/**
 *   '$RCSfile: LSIDTreeException.java,v $'
 *
 *   '$Author: berkley $'
 *   '$Date: 2006/01/04 22:03:52 $'
 *   '$Revision: 1.6 $'
 *
 *  For Details: http://kepler-project.org
 *  Copyright (c) 2003-2004 The Regents of the University of California.
 *  All rights reserved.
 *  Permission is hereby granted, without written agreement and without
 *  license or royalty fees, to use, copy, modify, and distribute this
 *  software and its documentation for any purpose, provided that the above
 *  copyright notice and the following two paragraphs appear in all copies
 *  of this software.
 *  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 *  FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 *  THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 *  PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 *  CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 *  ENHANCEMENTS, OR MODIFICATIONS.
 *  PT_COPYRIGHT_VERSION_2
 *  COPYRIGHTENDKEY
 */
package org.kepler.objectmanager.lsid;


/**
 * this class deals with exceptions thrown from the LSIDTree class
 */
public class LSIDTreeException extends RuntimeException
{
  public int lastObject;
  public int lastRevision;
  public KeplerLSID lsid;
  
  /**
   * construct a new LSIDTreeException
   */
  public LSIDTreeException(String msg)
  {
    super(msg);
  }
  
  /**
   * construct a new LSIDTreeException
   */
  public LSIDTreeException(KeplerLSID lsid, int lastObj, int lastRev)
  {
    super("LSID " + lsid.toString() + " already exists.");
    this.lastObject = lastObj;
    this.lastRevision = lastRev;
    this.lsid = lsid;
  }
}
