package org.kepler.scia;

import org.apache.lucene.index.TermFreqVector;


/**
 * @author uchukmol
 */
public class CompareDescVector {
    private static TermFreqVector getMaxSizeVector(TermFreqVector v1,
        TermFreqVector v2) throws NullPointerException {
        if (v1.size() > v2.size()) {
            return v1;
        } else {
            return v2;
        }
    }

    private static TermFreqVector getMinSizeVector(TermFreqVector v1,
        TermFreqVector v2) {
        if (v1.size() > v2.size()) {
            return v2;
        } else {
            return v1;
        }
    }

    public static double computeVectorCosine(TermFreqVector v1,
        TermFreqVector v2) {
        TermFreqVector tvec_min = getMinSizeVector(v1, v2);
        TermFreqVector tvec_max = getMaxSizeVector(v1, v2);

        Integer[] vector_array_2 = new Integer[tvec_max.size()];

        try {
            for (int k = 0; k <= tvec_max.size(); k++) {
                vector_array_2[k] = (new Integer(0));
            }
        } catch (ArrayIndexOutOfBoundsException e) {
        }

        for (int i = 0; i <= tvec_min.size(); i++) {
            try {
                int x = tvec_max.indexOf((tvec_min.getTerms())[i]);

                if (x != -1) {
                    //le terme existe dans les deux vecteurs
                    vector_array_2[x] = (new Integer((tvec_min.getTermFrequencies())[i]));
                }
            } catch (ArrayIndexOutOfBoundsException e) {
            }
        }

        double sum = 0.0;
        double magnitude_v1 = 0.0;
        double magnitude_v2 = 0.0;

        try {
            for (int j = 0; j <= tvec_max.size(); j++) {
                sum += (vector_array_2[j].intValue() * (tvec_max.getTermFrequencies())[j]);
                magnitude_v1 += ((vector_array_2[j].intValue()) * (vector_array_2[j].intValue()));
                magnitude_v2 += ((tvec_max.getTermFrequencies())[j] * (tvec_max.getTermFrequencies())[j]);
            }
        } catch (ArrayIndexOutOfBoundsException e) {
        }

        double result = (sum / (Math.sqrt(magnitude_v1) * Math.sqrt(magnitude_v2)));

        String s = "" + result;

        if (s.length() > 5) {
            s = s.substring(0, 4);
        }

        result = (new Double(s)).doubleValue();

        return result;
    }
}
