/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/************************************************
 * Allows the user to select among passed-in options
 * the public attribute data allows the caller method
 * to get the selected option.
 *
 * @author Vitaliy Zavesov
 ************************************************/
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;


public class Interactive2 extends JFrame {
    // global variables so that they could be set
    public String data = new String();

    // global variables so that they could be set
    public String prompt;
    public Vector valueVector;

    // constructor
    public Interactive2(final String p, final Vector v) {
        setTitle(" ");

        // setting the global variable
        prompt = p;
        valueVector = v;

        // position our popup window in the center of the screen
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();

        TextCanvas can = new TextCanvas(prompt);
        can.repaint();
        setFont(can.f);

        ActionListener al = new ActionListener() {
                public void actionPerformed(ActionEvent ae) {
                    data = ae.getActionCommand();
                    hide();
                }
            };

        //Group the radio buttons.
        ButtonGroup group = new ButtonGroup();

        // setting up the panel with the radio buttons
        JPanel pan = new JPanel();

        pan.setLayout(new BoxLayout(pan, BoxLayout.Y_AXIS));

        //Create the radio buttons.
        for (int i = 0; i < valueVector.size(); i++) {
            JRadioButton button = new JRadioButton((String) valueVector.elementAt(
                        i));
            String counterStr = "" + (i + 1);
            button.setActionCommand(counterStr);
            group.add(button);
            button.addActionListener(al);
            pan.add(button);
        }

        KeyAdapter kl = new KeyAdapter() {
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == KeyEvent.VK_ENTER) {
                        data = (String) valueVector.elementAt(0);
                        hide();
                    }
                }
            };

        FontMetrics fm = getFontMetrics(can.f);
        int size = (fm.getHeight() + 6) * (can.cnt + 1 + valueVector.size());
        size += 75;
        setSize(500, size);

        setLocation(d.width - this.getWidth(), d.height - this.getHeight() -
            30);
        addKeyListener(kl);

        getContentPane().add(can, "Center");
        getContentPane().add(pan, "South");
    }
}
