/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

import org.semanticweb.owl.impl.model.OWLConnectionImpl;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorHandler;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.helper.OntologyHelper;
import org.xml.sax.SAXException;


public class MyOntologyParser {
    //public static final int OWLRDF = 0;
    //public static final int Abstract = 1;
    OWLOntology ontology; //the main ontology in the owl file
    OWLMetadata metadata;

    // hash table to hold the children of each valid node in the schema tree
    Hashtable subClassHash = new Hashtable();

    // classes without superclass in the ontology file    
    Set rootClasses = new HashSet();

    /* the key that is the uri string of owl:Thing, to access subclass hash
       to get all original root classes */
    String rootKey;
    String ontologyRootTag = "Thing";
    long count = 0;

    public MyOntologyParser() {
    }

    public void parse(String fileName) {
        /*
        InputStream is = this.getClass().getResourceAsStream(fileName);
        if (is == null)
            if(SCIA.debug_on) System.err.println("InputStream = null");
        else
            if(SCIA.debug_on) System.err.println("InputStream of " + fileName + " = " +
                               is.available());
        */
        File f = new File(fileName);
        parse(f.toURI());

        //parse(is.toURI());
    }

    public void parse(URL url) {
        URI uri = null;

        try {
            uri = new URI(url.toString());
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }

        parse(uri);
    }

    //Existing owl:Thing is skipped 12/3/04
    public void parse(URI uri) {
        try {
            OWLRDFParser parser = new OWLRDFParser();
            OWLConnectionImpl conn = new OWLConnectionImpl();

            parser.setConnection(conn);

            OWLRDFErrorHandler handler = new OWLRDFErrorHandler() {
                    public void owlFullConstruct(int code, String message)
                        throws SAXException {
                        if (SCIA.debug_on) {
                            System.err.println("owlFullConstruct: " + message);
                        }
                    }

                    public void error(String message) throws SAXException {
                        if (SCIA.debug_on) {
                            System.err.println("ERROR: " + message);
                        }
                    }

                    public void warning(String message)
                        throws SAXException {
                        if (SCIA.debug_on) {
                            System.err.println("WARNING: " + message);
                        }
                    }
                };

            parser.setOWLRDFErrorHandler(handler);
            ontology = parser.parseOntology(uri);

            metadata = new OWLMetadata(ontology, parser.getPrefixMap());

            //identify whether the ontology is single rooted at "owl:Thing"
            Set classes = ontology.getClasses();

            Iterator it = classes.iterator();

            boolean thingExist = false; //owl:Thing exists or not

            // there exists a class without superclass but not owl:Thing
            boolean nonThingRootExist = false;

            while (it.hasNext()) {
                OWLClass cls = (OWLClass) it.next();
                Set superClasses = cls.getSuperClasses(ontology);

                if ((superClasses == null) || superClasses.isEmpty()) {
                    //rootClasses.add(cls);
                    URI clsuri = cls.getURI();

                    if (clsuri != null) {
                        String shortForm = metadata.shortForm(clsuri);

                        //System.err.println("shortform=" + shortForm);
                        if (shortForm.equals("owl:Thing")) {
                            thingExist = true;
                        } else {
                            nonThingRootExist = true;
                            rootClasses.add(cls); //skip existing owl:Thing
                        }

                        /*String str = clsuri.toString();
                        if(SCIA.debug_on) System.err.println("root class uri=" + str);

                        Set subc = getSubClasses(cls, ontology);
                        if (subc != null) {
                            Iterator subit = subc.iterator();
                            while (subit.hasNext()) {
                                OWLClass subcls = (OWLClass)subit.next();
                                String suburi = ((URI)subcls.getURI()).toString();

                                if(SCIA.debug_on) System.err.println("root class " + shortForm +
                                                   "'s subclass uri= "+ suburi);
                            }
                        }*/
                    }
                }
            }

            if (SCIA.debug_on) {
                System.err.println(
                    "in MyOntologyParser.parse(): rootCLasses = " +
                    rootClasses);
            }

            //if (rootClasses != null && !rootClasses.isEmpty() &&
            //	!thingExist && nonThingRootExist) {
            //TODO consider owl:Thing exists or not
            // just add owl:Thing as single root, 
            // not caring owl:Thing exists or not
            if ((rootClasses != null) && !rootClasses.isEmpty()) {
                //add owl:Thing as single root, is superclass of all orginal 
                //root classes
                //hash owl:Thing --> original root classes
                URI thingUri = metadata.uriFromShortForm("owl:Thing");
                rootKey = thingUri.toString();
                hashChildren(null, true);
            }
        } catch (OWLException e) {
            e.printStackTrace();
        }

        if (SCIA.debug_on) {
            System.err.println("in MyOntologyParser.parse(): subclassHash= " +
                subClassHash);
        }
    }

    public static String getRDFSLabel(OWLNamedObject owlObj,
        OWLOntology ontology) {
        try {
            Set labls = OntologyHelper.getRDFLabels(ontology, owlObj);

            if (labls != null) {
                Iterator it = labls.iterator();

                if (it.hasNext()) {
                    return (String) it.next();
                } else {
                    return null;
                }
            }
        } catch (OWLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        return null;
    }

    /********
             public void write(OutputStream out, int format) throws Exception {
                    String uri;
                    GraphToOWL g = new GraphToOWL(esdOntoBrowser);
                    OWLOntology onto = g.buildOWLOntology(getBaseURI());

                    if (onto != null) {
                            OutputStreamWriter w = new OutputStreamWriter(out);
                            if (format == OWLRDF) {
                                    MyRenderer r = new MyRenderer(metadata);
                                    r.renderOntology(onto, w);
                            } else {
                                    Renderer r = new Renderer();
                                    r.renderOntology(onto, w);
                            }
                            w.flush();
                    }
            }

            public String getBaseURI() {
                    return metadata.getBaseURI().toString();
            }

            public void setBaseURI(String s) throws URISyntaxException {
                    metadata.setBaseURI(new URI(s));
            }

            public static void addLabelPrefix(OBRelationNode rn, String lbl) {
                    String label;
                    switch (rn.relationSubCategory) {

                            case RenderGrowl.REL_OBJECT_PROPERTY_RESTRICT_SOME :
                            case RenderGrowl.REL_DATA_PROPERTY_RESTRICT_SOME :
                                    label = "\u2203:" + lbl;
                                    break;
                            case RenderGrowl.REL_OBJECT_PROPERTY_RESTRICT_ALL :
                            case RenderGrowl.REL_DATA_PROPERTY_RESTRICT_ALL :
                                    label = "\u2200:" + lbl;
                                    ;
                                    break;
                            case RenderGrowl.REL_OBJECT_PROPERTY_RESTRICT_CARD :
                            case RenderGrowl.REL_DATA_PROPERTY_RESTRICT_CARD :
                                    if (rn.minCardinality == rn.maxCardinality
                                            && rn.maxCardinality > -1)
                                            label = String.valueOf(rn.maxCardinality) + ':' + lbl;
                                    else if (rn.maxCardinality > 0 && rn.minCardinality > 0)
                                            label =
                                                    "["
                                                            + String.valueOf(rn.minCardinality)
                                                            + ","
                                                            + String.valueOf(rn.maxCardinality)
                                                            + "]:"
                                                            + lbl;
                                    else if (rn.minCardinality > 0 && rn.maxCardinality == -1)
                                            label =
                                                    "\u2265"
                                                            + String.valueOf(rn.minCardinality)
                                                            + ':'
                                                            + lbl;
                                    else if (rn.minCardinality <= 0 && rn.maxCardinality > 0)
                                            label =
                                                    "\u2264"
                                                            + String.valueOf(rn.maxCardinality)
                                                            + ':'
                                                            + lbl;
                                     else
                                             label = lbl;
                                    break;

                            default :{
                                    //label = lbl;
                                    rn.setLabel(lbl);
                                 return;
                            }

                    }

                    rn.setNodeLabel(label);
            }

            public static String stripLabel(String lbl ) {
                    if(lbl==null) return null;
                    //String lbl = rn.getLabel();
                    int pos = lbl.indexOf(':');
                    if (pos > 0 && !Character.isLetter(lbl.charAt(0))) {
                            return lbl.substring(pos + 1);
                    }
                    return lbl;
            }

            public static String stripNamespace(String lbl ) {
                    if(lbl==null) return null;
                    //String lbl = rn.getLabel();
                    int pos = lbl.indexOf(':');
                    if (pos > 0 && Character.isLetter(lbl.charAt(0))) {
                            return lbl.substring(pos + 1);
                    }
                    return lbl;
            }


            public OWLOntology getOntology() {
                    return currentOntology;
            }

            public Set getIncludeOntologies() {
                    return includeOntologies;
            }

            public OWLMetadata getMetadata() {
                    return metadata;
            }

            class MyRenderer extends org.semanticweb.owl.io.owl_rdf.Renderer {
                    OWLMetadata metadata;

                    MyRenderer(OWLMetadata m) {
                            super();
                            metadata = m;
                    }

                    protected void writeNamespacePrefixes() {

                            pw.println("<rdf:RDF");
                            List namespaces = metadata.getNamespaces();
                            for (Iterator i = namespaces.iterator(); i.hasNext();) {
                                    OWLMetadata.NameSpace ns = (OWLMetadata.NameSpace) i.next();
                                    pw.println(
                                            " xmlns:"
                                                    + ns.getPrefix()
                                                    + "=\""
                                                    + ns.getUri().toString()
                                                    + "\"");
                            }
                            pw.println(" xmlns=\"" + metadata.getBaseURI().toString() + "#\"");
                            pw.println(
                                    "xml:base=\"" + metadata.getBaseURI().toString() + "\">");
                    }

                    public String shortForm(URI uri) {
                            return metadata.shortForm(uri);
                    }

                    public boolean isLocal(URI uri) {
                            String s = metadata.getPrefixOfFullURI(uri);
                            return s == null || s.length() == 0;
                    }

            }


    */

    //hash subclass of current class into subClassHash table
    public void hashChildren(OWLClass current, boolean isRoot) {
        //count++;
        //System.err.println("\n*****count = " + count);
        //System.err.println("in hashChildren(): rootKey = " + rootKey);
        String key;

        //handling added owl:Thing
        if ((current == null) && isRoot) {
            key = rootKey;
            subClassHash.put(key, rootClasses);

            //System.err.println("in MyOntologyParser.hashChildren() after put +            //   " rootClasses: subclassHash= " + subClassHash);
            Iterator it = rootClasses.iterator();

            while (it.hasNext()) {
                OWLClass cls = (OWLClass) it.next();

                if (cls != null) {
                    hashChildren(cls, false);
                }
            }

            return;
        }

        Set children = getSubClasses(current, ontology);

        //hash its children
        if (children != null) {
            try {
                URI uri = current.getURI();
                key = uri.toString();

                //System.err.println("\n**" + key + "'s children = " +children);

                /*String rdfsLabel = getRDFSLabel(cls, ontology);
                if (rdfsLabel != null){
                        newObj.setNodeLabel(metadata.getNamespacePrefix(uri) +
                        rdfsLabel);
                        }*/
                if (key != null) {
                    subClassHash.put(key, children);
                }
            } catch (OWLException e) {
                e.printStackTrace();
            }

            //handle each child
            Iterator iterator = children.iterator();

            while (iterator.hasNext()) {
                OWLClass child = (OWLClass) iterator.next();
                hashChildren(child, false);
            }
        }
    }

    public Set getSubClasses(OWLClass cls, OWLOntology onto) {
        Set subClasses = new HashSet();

        try {
            Set classes = onto.getClasses();
            Iterator it = classes.iterator();

            while (it.hasNext()) {
                OWLClass c = (OWLClass) it.next();

                if (cls != c) {
                    Set superClasses = c.getSuperClasses(onto);

                    if ((superClasses != null) && !superClasses.isEmpty()) {
                        Iterator sit = superClasses.iterator();

                        while (sit.hasNext()) {
                            OWLClass sc = (OWLClass) sit.next();

                            if (sc == cls) {
                                subClasses.add(c);
                            }
                        }
                    }
                }
            }
        } catch (OWLException e) {
            e.printStackTrace();
        }

        return subClasses;
    }

    public static void main(String[] args) {
        MyOntologyParser pr = new MyOntologyParser();
        String fileName = "food_m.owl";

        try {
            pr.parse(fileName);
        } catch (Exception e) {
            if (SCIA.debug_on) {
                System.err.println("exception");
            }
        }
    }
}
