/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;

import java.io.PrintWriter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

import java.util.Vector;


/**
 * MySQLDataBase is for creating tables and building SchemaTree from a
 * resultset.
 *
 * @author Guilian Wang
 */
public class MySQLDataBase {
    public static void createTable(Connection conn) {
        Statement stmt = null;
        ResultSet rs = null;
        String query;

        try {
            stmt = conn.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,
                    ResultSet.CONCUR_READ_ONLY);
            query = "DROP TABLE StudyC";
            stmt.execute(query);
            query = "CREATE TABLE StudyC " + "(date VARCHAR(10) NOT NULL, " +
                "site VARCHAR(10) NOT NULL, " +
                "species VARCHAR(10) NOT NULL, " + "count INT NOT NULL, " +
                "area REAL NOT NULL)";

            stmt.execute(query);
            query = "INSERT INTO StudyC VALUES " +
                "('10/1/1993', 'N654', 'PIRU', 29, 2), " +
                "('10/3/1994', 'N654', 'PIRU', 26, 2), " +
                "('10/1/1993', 'N654', 'BEPA', 3, 1)";
            stmt.execute(query);

            query = "SELECT * FROM StudyC";

            if (stmt.execute(query)) {
                rs = stmt.getResultSet();

                ResultSetMetaData rsmd = rs.getMetaData();
                int nc = rsmd.getColumnCount();

                if (SCIA.debug_on) {
                    System.err.println("nc = " + nc);
                }

                if (SCIA.debug_on) {
                    System.err.println("1st columnName = " +
                        rsmd.getColumnName(1));
                }

                String date;
                float area;

                //rs.last();
                //int rn = rs.getRow();
                //System.out.println("rn = " + rn);
                while (rs.next()) {
                    date = rs.getString("date");
                    area = rs.getFloat("area");

                    if (SCIA.debug_on) {
                        System.err.println("date = " + date + " area = " +
                            area);
                    }
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();

            if (SCIA.debug_on) {
                System.err.println("SQLState: " + e.getSQLState());
            }

            if (SCIA.debug_on) {
                System.err.println("VendorError: " + e.getErrorCode());
            }
        }
    }

    public static SchemaTree toSchemaTree(String dbName, Connection conn) {
        SchemaTree tree = new SchemaTree();
        tree.schemaType = "SQL";

        ResultSet rs;
        ResultSet rs1;
        String tableName;
        String colName;
        String typeName;
        String minOccur;
        String maxOccur;

        //put the database name as the root of schema tree
        tree.occupancy++;

        SchemaNode root = new SchemaNode(dbName, "rootElem", "");
        tree.rootNode = new TNode(root);
        tree.rootNode.height = 0;
        tree.rootNode.tree = tree;

        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getTables(null, null, null, null);

            while (rs.next()) {
                tableName = rs.getString("TABLE_NAME");

                //each table as a child of the tree root
                SchemaNode tableNode = new SchemaNode(tableName, "parentElem",
                        "");

                TNode tbTNode = new TNode(tableNode);
                tbTNode.height = 1;

                if (tree.rootNode.children == null) {
                    tree.rootNode.children = new Vector();
                }

                tree.rootNode.children.addElement(tbTNode);

                //add row TNode
                SchemaNode rowNode = new SchemaNode("row", "parentElem", "");

                TNode rowTNode = new TNode(rowNode);
                rowTNode.height = 2;

                if (tbTNode.children == null) {
                    tbTNode.children = new Vector();
                }

                tbTNode.children.addElement(rowTNode);

                //add columns TNodes as children of row TNode for each table 
                rs1 = dbmd.getColumns(null, null, tableName, null);

                while (rs1.next()) {
                    colName = rs1.getString("COLUMN_NAME");

                    //dataType = rs1.getInt("DATA_TYPE");
                    typeName = rs1.getString("TYPE_NAME");

                    if (rs1.getString("IS_NULLABLE").equals("NO")) {
                        minOccur = maxOccur = "1";
                    } else {
                        minOccur = "0";
                        maxOccur = "1";
                    }

                    SchemaNode colNode = new SchemaNode(colName, "leafElem",
                            typeName, minOccur, maxOccur);

                    if (SCIA.debug_on) {
                        System.err.println(" colName=" + colName +
                            " minOccur=" + minOccur + " typeName=" + typeName);
                    }

                    TNode colTNode = new TNode(colNode);
                    colTNode.height = 3;

                    if (rowTNode.children == null) {
                        rowTNode.children = new Vector();
                    }

                    rowTNode.children.addElement(colTNode);
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();

            if (SCIA.debug_on) {
                System.err.println("SQLState: " + e.getSQLState());
            }

            if (SCIA.debug_on) {
                System.err.println("VendorError: " + e.getErrorCode());
            }
        }

        return tree;
    }

    public static void main(String[] args) {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();

            Connection conn = DriverManager.getConnection(
                    "jdbc:mysql://www.freesql.org:3306" +
                    "/fieldDB?user=jenny2004&password=jenny2004");
            createTable(conn);

            SchemaTree tr = toSchemaTree("fieldDB", conn);
            PrintWriter cout = new PrintWriter(System.out, true);
            tr.write(cout, false);
        } catch (SQLException e) {
            e.printStackTrace();

            if (SCIA.debug_on) {
                System.err.println("SQLState: " + e.getSQLState());
            }

            if (SCIA.debug_on) {
                System.err.println("VendorError: " + e.getErrorCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
