/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


//import org.ecoinformatics.seek.ontobrowser.ESDOntoBrowser;
//import org.ecoinformatics.seek.ontobrowser.KRPolicy;
//import org.ecoinformatics.seek.ontobrowser.KRPolicyWrite;
//import org.ecoinformatics.seek.ontobrowser.OBRelationNode;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;

import org.semanticweb.owl.impl.model.OWLConnectionImpl;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorHandler;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLOntology;
import org.xml.sax.SAXException;


//import com.touchgraph.graphlayout.TGPanel;

/**
 * From GrOWL package.
 */
public class OWLReader {
    public static final int OWLRDF = 0;
    public static final int Abstract = 1;

    //TGPanel tgPanel;
    //ESDOntoBrowser esdOntoBrowser;
    OWLRDFParser parser = null;
    OWLOntology currentOntology = null;

    //BuildGraphVisitor visitor = null;
    Set includeOntologies = null;

    //OWLMetadata metadata;
    //boolean multiplePropertyCopies = false;
    //public boolean processIncludeOntologies = true;
    public OWLReader() {
        //metadata = new OWLMetadata();
        //metadata.setDefaults();
    }

    public void read(String fileName, Thread afterReading)
        throws Exception {
        URI uri = null;
        File f = new File(fileName);
        read(f.toURI(), afterReading);
    }

    public void read(URL url, Thread afterReading) throws Exception {
        URI uri = null;

        try {
            uri = new URI(url.toString());
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }

        read(uri, afterReading);
    }

    public void read(URI uri, Thread afterReading) throws Exception {
        parser = new OWLRDFParser();

        OWLConnectionImpl conn = new OWLConnectionImpl();
        parser.setConnection(conn);

        OWLRDFErrorHandler handler = new OWLRDFErrorHandler() {
                public void owlFullConstruct(int code, String message)
                    throws SAXException {
                    if (SCIA.debug_on) {
                        System.err.println("owlFullConstruct: " + message);
                    }
                }

                public void error(String message) throws SAXException {
                    if (SCIA.debug_on) {
                        System.err.println("ERROR: " + message);
                    }
                }

                public void warning(String message) throws SAXException {
                    if (SCIA.debug_on) {
                        System.err.println("WARNING: " + message);
                    }
                }
            };

        parser.setOWLRDFErrorHandler(handler);

        OWLOntology ontology = parser.parseOntology(uri);
        currentOntology = ontology;

        /*
        OWLtoGraph owl2g= new OWLtoGraph(esdOntoBrowser);
        owl2g.buildGraphEltSet(ontology, parser.getPrefixMap());
        metadata=owl2g.getMetadata();

        if (afterReading != null)
            afterReading.start();
        */
    }

    /********
                    public void write(OutputStream out, int format) throws Exception {
                    String uri;
                    GraphToOWL g = new GraphToOWL(esdOntoBrowser);
                    OWLOntology onto = g.buildOWLOntology(getBaseURI());

                    if (onto != null) {
                            OutputStreamWriter w = new OutputStreamWriter(out);
                            if (format == OWLRDF) {
                                    MyRenderer r = new MyRenderer(metadata);
                                    r.renderOntology(onto, w);
                            } else {
                                    Renderer r = new Renderer();
                                    r.renderOntology(onto, w);
                            }
                            w.flush();
                    }
            }

            public String getBaseURI() {
                    return metadata.getBaseURI().toString();
            }

            public void setBaseURI(String s) throws URISyntaxException {
                    metadata.setBaseURI(new URI(s));
            }

            public static void addLabelPrefix(OBRelationNode rn, String lbl) {
                    String label;
                    switch (rn.relationSubCategory) {

                            case RenderGrowl.REL_OBJECT_PROPERTY_RESTRICT_SOME :
                            case RenderGrowl.REL_DATA_PROPERTY_RESTRICT_SOME :
                                    label = "\u2203:" + lbl;
                                    break;
                            case RenderGrowl.REL_OBJECT_PROPERTY_RESTRICT_ALL :
                            case RenderGrowl.REL_DATA_PROPERTY_RESTRICT_ALL :
                                    label = "\u2200:" + lbl;
                                    ;
                                    break;
                            case RenderGrowl.REL_OBJECT_PROPERTY_RESTRICT_CARD :
                            case RenderGrowl.REL_DATA_PROPERTY_RESTRICT_CARD :
                                    if (rn.minCardinality == rn.maxCardinality
                                            && rn.maxCardinality > -1)
                                            label = String.valueOf(rn.maxCardinality) + ':' + lbl;
                                    else if (rn.maxCardinality > 0 && rn.minCardinality > 0)
                                            label =
                                                    "["
                                                            + String.valueOf(rn.minCardinality)
                                                            + ","
                                                            + String.valueOf(rn.maxCardinality)
                                                            + "]:"
                                                            + lbl;
                                    else if (rn.minCardinality > 0 && rn.maxCardinality == -1)
                                            label =
                                                    "\u2265"
                                                            + String.valueOf(rn.minCardinality)
                                                            + ':'
                                                            + lbl;
                                    else if (rn.minCardinality <= 0 && rn.maxCardinality > 0)
                                            label =
                                                    "\u2264"
                                                            + String.valueOf(rn.maxCardinality)
                                                            + ':'
                                                            + lbl;
                                     else
                                             label = lbl;
                                    break;

                            default :{
                                    //label = lbl;
                                    rn.setLabel(lbl);
                                 return;
                            }

                    }

                    rn.setNodeLabel(label);
            }

            public static String stripLabel(String lbl ) {
                    if(lbl==null) return null;
                    //String lbl = rn.getLabel();
                    int pos = lbl.indexOf(':');
                    if (pos > 0 && !Character.isLetter(lbl.charAt(0))) {
                            return lbl.substring(pos + 1);
                    }
                    return lbl;
            }

            public static String stripNamespace(String lbl ) {
                    if(lbl==null) return null;
                    //String lbl = rn.getLabel();
                    int pos = lbl.indexOf(':');
                    if (pos > 0 && Character.isLetter(lbl.charAt(0))) {
                            return lbl.substring(pos + 1);
                    }
                    return lbl;
            }


            public OWLOntology getOntology() {
                    return currentOntology;
            }

            public Set getIncludeOntologies() {
                    return includeOntologies;
            }

            public OWLMetadata getMetadata() {
                    return metadata;
            }

            class MyRenderer extends org.semanticweb.owl.io.owl_rdf.Renderer {
                    OWLMetadata metadata;

                    MyRenderer(OWLMetadata m) {
                            super();
                            metadata = m;
                    }

                    protected void writeNamespacePrefixes() {

                            pw.println("<rdf:RDF");
                            List namespaces = metadata.getNamespaces();
                            for (Iterator i = namespaces.iterator(); i.hasNext();) {
                                    OWLMetadata.NameSpace ns = (OWLMetadata.NameSpace) i.next();
                                    pw.println(
                                            " xmlns:"
                                                    + ns.getPrefix()
                                                    + "=\""
                                                    + ns.getUri().toString()
                                                    + "\"");
                            }
                            pw.println(" xmlns=\"" + metadata.getBaseURI().toString() + "#\"");
                            pw.println(
                                    "xml:base=\"" + metadata.getBaseURI().toString() + "\">");
                    }

                    public String shortForm(URI uri) {
                            return metadata.shortForm(uri);
                    }

                    public boolean isLocal(URI uri) {
                            String s = metadata.getPrefixOfFullURI(uri);
                            return s == null || s.length() == 0;
                    }

            }


    */
    public static void main(String[] args) {
        OWLReader r = new OWLReader();
        String fileName = "food.owl";

        try {
            r.read(fileName, null);
        } catch (Exception e) {
            if (SCIA.debug_on) {
                System.err.println("exception");
            }
        }
    }
}
