/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.JFrame;


public class OperationPopup extends JFrame {
    // constructor
    public OperationPopup(final MatchLine selLine) {
        // position our popup window in the center of the screen
        Toolkit tk = Toolkit.getDefaultToolkit();

        int screenRes = tk.getScreenResolution();

        int fontSize = (int) Math.round((12.0 * screenRes) / 72.0);

        Font font = new Font("Arial", Font.PLAIN, fontSize);

        setFont(font);

        Dimension d = tk.getScreenSize();

        if (SCIA.debug_on) {
            System.err.println(d.width);
        }

        if (SCIA.debug_on) {
            System.err.println(d.height);
        }

        setLocation((d.width / 2) - (d.width / 8), (d.height / 2) - fontSize);

        setSize((fontSize * 20) + 4, fontSize * 5);

        setTitle("Operation");

        final TextField textField = new TextField(20);

        KeyAdapter kl = new KeyAdapter() {
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == KeyEvent.VK_ENTER) {
                        if (SCIA.debug_on) {
                            System.err.println(
                                "The user entered the operation:");
                        }

                        if (SCIA.debug_on) {
                            System.err.println(textField.getText());
                        }

                        if (selLine != null) {
                            selLine.rightTNode.fromComb.operations = textField.getText();
                            selLine.operations = textField.getText();
                        }

                        hide();
                    }
                }
            };

        textField.addKeyListener(kl);

        // setting up the panel with the text area
        Panel p = new Panel();

        p.add(textField);

        getContentPane().add(p, "Center");
    }
}
