/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/************************************************
 * Variable-length text canvas used in Interactive
 * classes
 *
 * @author Vitaliy Zavesov
 ************************************************/
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;


class TextCanvas extends Canvas {
    String prompt;
    public Font f = new Font("SansSerif", Font.BOLD, 14);
    public int cnt = 0;

    public TextCanvas(final String p) {
        prompt = p;
    }

    public void paint(Graphics g) {
        FontMetrics fm = getFontMetrics(f);

        // first, we do the text-wrapping
        String[] wrap = new String[100];

        StringTokenizer st = new StringTokenizer(prompt);
        String next = st.nextToken();
	cnt = 0;
        wrap[cnt] = next;

        while (st.hasMoreTokens()) {
            next = st.nextToken();

            if (fm.stringWidth(wrap[cnt] + " " + next) < 490) {
                wrap[cnt] += (" " + next);
            } else {
                cnt++;
                wrap[cnt] = next;
            }
        }

        g.setFont(f);

        int cnt2 = 0;

        for (int cnt1 = 0; cnt1 <= cnt; cnt1++) {
            if (wrap[cnt1] != null) {

                g.drawString(wrap[cnt1] + "\n", 1, (cnt2 + 1) * 14);
                cnt2++;
            }
        }
    }
}
;
