/* Removes from data stream collections based on their types.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */

package org.nddp.coactors;

import java.util.Set;

import org.nddp.CollectionManager;
import org.nddp.CollectionHandler;
import org.nddp.util.Parameters;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.coactor type="general"
 */
public class CollectionTypeFilter extends CollectionTransformer {

    public CollectionTypeFilter(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException {

        super(container, name);
        
        collectionsToKeep = Parameters.stringArrayParameter(
                this, "collectionsToKeep" );
        
        collectionsToDiscard = Parameters.stringArrayParameter(
                this,"collectionsToDiscard");
	}

	///////////////////////////////////////////////////////////////////
	////                         public variables                  ////
  
	public Parameter collectionsToDiscard;
	public Parameter collectionsToKeep;
	
	///////////////////////////////////////////////////////////////////
	////                      protected methods                    //// 
  
    public CollectionHandler.CollectionDisposition _handleCollectionStart (CollectionManager
            collectionManager) {

		if (! _collectionsToKeep.isEmpty()) {

		    if (_collectionsToKeep.contains(
		            collectionManager.collection().getClass())) {
		        
				return CollectionHandler.IGNORE_AND_FORWARD_COLLECTION;
				
			} else {
			    
				return  CollectionHandler.IGNORE_AND_DISCARD_COLLECTION;
			}
		}
	        
        if (_collectionsToDiscard.contains(
                collectionManager.collection().getClass())) {
            
        		return CollectionHandler.IGNORE_AND_DISCARD_COLLECTION;
        		
        } else {
            
	    	    return CollectionHandler.IGNORE_AND_FORWARD_COLLECTION;
        } 
   	}   

    public void _handleParameterChange(Parameter parameter, Token value)
  		throws IllegalActionException {
            
        if (parameter == collectionsToDiscard ) {
            
        		_collectionsToDiscard = 
        		    Parameters.collectionTypeSetValue(value);
        		
        } else if (parameter == collectionsToKeep ) {
            
        		_collectionsToKeep = 
        		    Parameters.collectionTypeSetValue(value);
        		
        } else {
            super._handleParameterChange(parameter, value);
        }
    }
    
	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

	private Set _collectionsToDiscard;	
	private Set _collectionsToKeep;
}
