/* Actor that filters from stream string tokens matching the given criterion.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */

package org.nddp.coactors;

import org.nddp.AtomicCoactor;
import org.nddp.CollectionHandler;
import org.nddp.CollectionManager;
import org.nddp.util.Parameters;

import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.data.expr.Parameter;

/**
 * @nddp.coactor type="general"
 */
public class StringFilter extends CollectionTransformer {

    public StringFilter(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException  {

        super(container, name);
        
        matchString = Parameters.stringParameter(this, "matchString", "");
        location = Parameters.intParameter(this, "location", 0);
    }

	///////////////////////////////////////////////////////////////////
	////                         public variables                  ////
    
    public Parameter location;
    public Parameter matchString;

	///////////////////////////////////////////////////////////////////
	////                      protected methods                    //// 
    
    public CollectionHandler.TokenDisposition _handleData(CollectionManager 
        collectionManager, Token token) throws IllegalActionException {
  	    
		if ( ((StringToken)token).stringValue().substring(_location, 
		        _location + _matchStringLength).equals(_matchString) ) {
		    
		    return CollectionHandler.FORWARD_TOKEN;
		    
		} else {
		    return CollectionHandler.DISCARD_TOKEN;
		}
  	}
  	
    public void _handleParameterChange(Parameter parameter, Token value) 
		throws IllegalActionException {
            
        if (parameter == matchString ) {
        
            _matchString = Parameters.stringValue(value);
            _matchStringLength = _matchString.length();
            
        } else if (parameter == location) {
        
            _location = Parameters.intValue(value);
            
        } else {
        
            super._handleParameterChange(parameter, value);
        }
    }

	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

    	private int _location;
  	private String _matchString;
    	private int _matchStringLength;    
}
