/* Actor that extracts protein sequences from protein chain collections.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 package org.nddp.coactors.proteins;

import org.nddp.AtomicCoactor;
import org.nddp.CollectionHandler;
import org.nddp.CollectionManager;
import org.nddp.DomainObject;
import org.nddp.coactors.CollectionTransformer;
import org.nddp.proteins.ProteinAtom;
import org.nddp.proteins.ProteinSequence;
import org.nddp.util.Parameters;

import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.coactor type="proteins"
 */
public class PDBChainSequenceExtractor extends CollectionTransformer {

	public PDBChainSequenceExtractor(CompositeEntity container, String name)
		throws NameDuplicationException, IllegalActionException {
		
	    super(container, name);
		
	    Parameters.fix(collectionPath, "ProteinChain/ProteinAtom");
	}

	///////////////////////////////////////////////////////////////////
	////                      protected methods                    //// 

    public void _handleCollectionEnd(CollectionManager collectionManager) 
		throws IllegalActionException  {
	    
  	     if (_sequence.length() > 0) {
			collectionManager.addDomainObject(_sequence);
   	     }
     }
		
    public CollectionHandler.CollectionDisposition _handleCollectionStart(CollectionManager 
        collectionManager) throws IllegalActionException {

    		_sequence = new ProteinSequence();   		
   		
    		return  CollectionHandler.PROCESS_AND_FORWARD_COLLECTION;
   	}

    public CollectionHandler.TokenDisposition _handleDomainObject(
         CollectionManager collectionManager, DomainObject object) 
   	 	throws IllegalActionException {
   	 	
   	     ProteinAtom atom = (ProteinAtom)object;
   	     
   		if (atom.residueNumber() != _currentResidueNumber) {
   			   		    
			_sequence.addResidue(atom.residueType());
			
            	_currentResidueNumber = atom.residueNumber();
   		}
   	 	
 		return  CollectionHandler.FORWARD_TOKEN;
  	}

	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////
   	 
    private int _currentResidueNumber = 0;
    private ProteinSequence _sequence;
}
