/* Handler class for Nexus characters blocks.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 package org.nddp.phylogeny;

import java.util.Iterator;

import org.nddp.CollectionManager;
import org.nddp.exceptions.IndexOutOfBoundsException;
import org.nddp.exceptions.ParseException;

import ptolemy.kernel.util.IllegalActionException;

class NexusDataBlockHandler extends NexusBlockHandler {
    
    public NexusDataBlockHandler(NexusBlock block, CollectionManager
        nexusFileCollectionManager) throws IllegalActionException {
        
		super(block, nexusFileCollectionManager);        
    }
 
	///////////////////////////////////////////////////////////////////
	////                         protected methods                 ////
    
    protected void _handleBlock() throws IllegalActionException, 
    		IndexOutOfBoundsException, ParseException {
	
    	    NexusCommand dimensionsCommand = _block.getCommand("DIMENSIONS");
    	    
    	    NexusCommand formatCommand = _block.getCommand("FORMAT");
    	    
    	    NexusCommand matrixCommand = _block.getCommand("MATRIX");
    	    
    	    int taxonCount = matrixCommand.argumentCount()/2;
    	    
    	    int characterCount = 
    	        Integer.parseInt(dimensionsCommand.getProperty("NCHAR"));
    	    
    	    CharacterMatrix matrix = 
    	        new CharacterMatrix(taxonCount, characterCount);
    	    
    	    String dataTypeString = formatCommand.getProperty("DATATYPE");
    	    
    	    if (dataTypeString.equals("PROTEIN")) {
	    	    matrix.setDataType(TaxonomicCharacter.PROTEIN_DATA);
    	    } else if (dataTypeString.equals("DNA")) {
	    	    matrix.setDataType(TaxonomicCharacter.DNA_DATA);
    	    } else if (dataTypeString.equals("RNA")) {
	    	    matrix.setDataType(TaxonomicCharacter.RNA_DATA);
    	    } else {
    	        throw new ParseException("Unsupported Nexus data type:" + dataTypeString);
    	    }

    	    matrix.setMissingSymbol(
    	            formatCommand.getProperty("MISSING").charAt(0));
    	    
    	    matrix.setGapSymbol(
    	            formatCommand.getProperty("GAP").charAt(0));
    	    
    	    int taxonIndex = 0;
    	    for (Iterator i = matrixCommand.argumentIterator(); 
    	    			i.hasNext(); i.next(), taxonIndex++) {
    	        
    	        String taxonName = (String) i.next();
    	        matrix.setTaxonName(taxonIndex, taxonName);
    	    }

    	    taxonIndex = 0;
    	    for (Iterator i = matrixCommand.argumentIterator(); 
    	    			i.hasNext(); taxonIndex++) {
    	        
    	        i.next();
    	        String characters = (String) i.next();
    	        matrix.addCharacterValues(taxonIndex, characters);
    	    }
    	        	    
    	    _nexusFileCollectionManager.addDomainObject(matrix);
	}
}