/* Base class for Phylip tree inference runners that jumble taxa.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.phylogeny.phylip;

import java.io.IOException;

import org.nddp.exceptions.ExternalApplicationException;

public abstract class PhylipJumblingRunner extends PhylipTreeInferenceRunner {

    public PhylipJumblingRunner() {
        
        super();
    }

	///////////////////////////////////////////////////////////////////
	////                         public methods                    ////    	
	
	public void jumbleTaxa(int count, int seed) {
	    _jumbleCount = count;
	    _jumbleSeed = seed;
	}
    
	///////////////////////////////////////////////////////////////////
	////                      protected methods                    ////    	

	protected void _writeStandardInput() 
    		throws ExternalApplicationException {
        
		try {
			// optionally jumble the taxa using the given random number seed
		    	if (_jumbleCount > 0) {
				_writeToProcess("J");
				_writeToProcess(String.valueOf(_jumbleSeed));
				_writeToProcess(String.valueOf(_jumbleCount));
		    	}

		} catch (IOException e) {
			throw new ExternalApplicationException(
		        "Error writing to process");
        	}
		
		super._writeStandardInput();
    }
    
    ///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

    	protected int _jumbleCount = 0;
	protected int _jumbleSeed;
}

