/* GridFTP...
 Copyright (c) 2000-2003 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.
 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.
 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.
                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
 */

package org.sdm.spa;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

import org.globus.ftp.GridFTPClient;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;

//////////////////////////////////////////////////////////////////////////
//// GridFTP
/**
 * This actor reads a set of files in a specified Globus machine, copies them
 * into a specified local directory, and sends back the list of file paths as
 * string when it is done.
 *
 * @author Ilkay Altintas (Built on top of Steve Mock's GridFTP.)
 * @version $Id: FileFetcher.java,v 1.4 2006/04/04 17:23:50 altintas Exp $
 */

public class FileFetcher
    extends TypedAtomicActor{

  public FileFetcher(CompositeEntity container, String name) throws
      IllegalActionException, NameDuplicationException {
    super(container, name);

    certificate = new TypedIOPort(this, "certificate", true, false);
    certificate.setTypeEquals(BaseType.STRING);
    new Attribute(certificate, "_showName");

    filesToGet = new TypedIOPort(this, "filesToGet", true, false);
    filesToGet.setTypeEquals(BaseType.STRING);
    new Attribute(filesToGet, "_showName");

    fetchedFiles = new TypedIOPort(this, "fetchedFiles", false, true);
    fetchedFiles.setTypeEquals(BaseType.STRING);
    new Attribute(fetchedFiles, "_showName");

    sourceHost = new StringAttribute(this, "SourceHostname");
    destDirPath = new StringAttribute(this, "DestinationDirectoryPath");

    _attachText("_iconDescription", "<svg>\n"
                + "<rect x=\"-25\" y=\"-20\" "
                + "width=\"50\" height=\"40\" "
                + "style=\"fill:white\"/>\n"
                + "<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10"
                + " 15,-10 15,8, -15,8\" "
                + "style=\"fill:red\"/>\n"
                + "<text x=\"-22\" y=\"19\""
                + "style=\"font-size:11; fill:black; font-family:SansSerif\">"
                + "FETCHER</text>\n"
                + "</svg>\n");
  }

  ///////////////////////////////////////////////////////////////////
  ////                     ports and parameters                  ////

  /**
   * The Globus proxy certificate generated by the GlobusProxy actor.
   */
  public TypedIOPort certificate;

  /**
   * The list of file paths to fetch in string form seperated by semicolons.
   */
  public TypedIOPort filesToGet;

  /**
  * The list of file paths for the copied files.
  * (In string form seperated by semicolons.)
  */
  public TypedIOPort fetchedFiles;

  /**
   * The url to get the files from.
   */
  public StringAttribute sourceHost;

  /**
   * Full path to the destination directory to copy the files into.
   */
  public StringAttribute destDirPath;

  ///////////////////////////////////////////////////////////////////
  ////                         public methods                    ////

  /** If the specified attribute is <i>fileOrURL</i> and there is an
   *  open file being read, then close that file and open the new one;
   *  if the attribute is <i>numberOfLinesToSkip</i> and its value is
   *  negative, then throw an exception.  In the case of <i>fileOrURL</i>,
   *  do nothing if the file name is the same as the previous value of
   *  this attribute.
   *  @param attribute The attribute that has changed.
   *  @exception IllegalActionException If the specified attribute
   *   is <i>fileOrURL</i> and the file cannot be opened, or the previously
   *   opened file cannot be closed; or if the attribute is
   *   <i>numberOfLinesToSkip</i> and its value is negative.
   */
  public void attributeChanged(Attribute attribute) throws
      IllegalActionException {

    super.attributeChanged(attribute);
  }

  /** Output the data lines into an array.
   *  @exception IllegalActionException If there's no director.
   */

  public void fire() throws IllegalActionException {
    super.fire();

    //Get the values of the parameters
    String sourceHostString = sourceHost.getExpression();
    _debug("<SOURCE_HOST_NAME>" + sourceHostString + "</SOURCE_HOST_NAME>");
    int sourcePort = 2811;
    String destHostString = "localhost";
    _debug("<DEST_HOST_NAME>" + sourceHostString + "</DEST_HOST_NAME>");
    String destDirPathString = destDirPath.getExpression();
    _debug("<DEST_PATH>" + destDirPathString + "</DEST_PATH>");
    int destPort = 2811;

    /* Consume the filesToPut token if there's one.
     */
    Token tokenFiles = null;
    String filesStream = null;
    try {
      tokenFiles = filesToGet.get(0);
    }
    catch (Exception ex) {
      _debug("filesToPut string is null.");
    }

//    try {
    ExtendedGSSManager manager = (ExtendedGSSManager) ExtendedGSSManager.
        getInstance();
    //get the proxy string fed into the input port
    Token token = null;
    try {
      token = certificate.get(0);

      if (token != null) {
        _proxy = manager.createCredential( (token.toString()).getBytes(),
                                          ExtendedGSSCredential.
                                          IMPEXP_OPAQUE,
                                          GSSCredential.DEFAULT_LIFETIME,
                                          null, // use default mechanism - GSI
                                          GSSCredential.
                                          INITIATE_AND_ACCEPT);

      }
    }
    catch (Exception ex) {
      _proxy = null;
      _debug("Proxy is null.");
    }
//    } catch (org.ietf.jgss.GSSException gsse) {
//      throw new IllegalActionException(failMsg + gsse.toString());
//    }

    String failMsg = "GridFTP transfer failed because of: ";

    if (tokenFiles != null) {
      filesStream = new String(tokenFiles.toString());
      _debug("<FILES_TO_PUT>" + filesStream + "<FILES_TO_PUT>");
      filesStream = filesStream.substring(1, filesStream.length() - 1);
    }
    //Tokenize the filesStream to get the name of each file.
    StringTokenizer st = new StringTokenizer(filesStream, ";", false);
    _destFileStream = "";
    while (st.hasMoreTokens()) {
      _sourceFileString = st.nextToken();
      _debug("<SOURCE_FILE_PATH>" + _sourceFileString + "</SOURCE_FILE_PATH>");

      int slashIndex = _sourceFileString.lastIndexOf('/');
      String tmpFileNameString = _sourceFileString.substring(slashIndex + 1);
      _destFileString = destDirPathString + "/" + tmpFileNameString;
      _debug("<DEST_FILE_PATH>" + _destFileString + "</DEST_FILE_PATH>");

      _destFileStream += _destFileString + ';';

      try {
        if (destHostString.equals("") || destHostString.equals("localhost")) {
          _gftpc = new GridFTPClient(sourceHostString, sourcePort);
          _gftpc.authenticate(_proxy);
          //_gftpc.get(_sourceFileString, new File(_destFileString));
          _gftpc.get(_sourceFileString, new File(_destFileString));
        }
      }
      catch (IOException ioe) {
        throw new IllegalActionException(failMsg + ioe.toString());
      }
      catch (org.globus.ftp.exception.ServerException se) {
        throw new IllegalActionException(failMsg + se.toString());
      }
      catch (org.globus.ftp.exception.ClientException ce) {
        throw new IllegalActionException(failMsg + ce.toString());
      }
    }
    _debug("Done with GridFTP transfer.");
    _destFileStream = _destFileStream.substring(0,_destFileStream.length() - 1);
    fetchedFiles.broadcast(new StringToken(_destFileStream));
  }

  public String getDestFileStream() {
    return _destFileStream;
  }

/**FIX ME: Implement;
 *  public void setDestHostName
 *  public void setDestDirPath
 * /


  /** Post fire the actor. Return false to indicated that the
   * process has finished. If it returns true, the process will
   * continue indefinitely.
   */

  public boolean postfire() {
    return false;
  }

  /** Open the file or URL and read the first line, and use the
   *  first line to set the type of the output.
   *  @exception IllegalActionException If the file or URL cannot be
   *  opened, or if the first line cannot be read.
   */
  public void preinitialize() throws IllegalActionException {
    super.preinitialize();
  }

  ///////////////////////////////////////////////////////////////////
  ////                         protected members                 ////

  ///////////////////////////////////////////////////////////////////
  ////                         private methods                   ////

  ///////////////////////////////////////////////////////////////////
  ////                         private members                   ////

  private GridFTPClient _gftpc;
  private GridFTPClient _gftpc_dest;
  private GSSCredential _proxy;

  private String _destFileString = "";
  private String _sourceFileString = "";
  private String _destFileStream = "";
  /** Result string Variable. */
  private String _result = new String("");

}