/* A GUI for assigning true or false values to things in a list

 Copyright (c) 1998-2005 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */
package ptolemy.actor;

import java.util.Map;
import java.util.Set;
import java.util.Iterator;
import javax.swing.BoxLayout;

import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;


//////////////////////////////////////////////////////////////////////////
//// NameTrueFalseQuery

/**
 This class provides a GUI to assign a true or false value to a list of
 names.  The input is a map that has the names and the true or false value
 that should be associated with that name by default.
 <p>
This is a simple GUI basically like the StyleConfigurer.

 @author Oscar Barney
 @version $Id: NameTrueFalseQuery.java,v 1.1 2006/01/19 00:37:02 barney Exp $
 @Pt.ProposedRating Red
 @Pt.AcceptedRating Red
 */
public class NameTrueFalseQuery extends Query implements QueryListener {
    /** Construct a configurer.
     *  @param namesAndValues The names and the associated true/false 
     *                                              values that are preexisting.
     */
    public NameTrueFalseQuery(Map namesAndValues, String display) {
        super();
        this.addQueryListener(this);
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

        setTextWidth(25);
        
        addDisplay("name" , "-", display);
        
        Set names = namesAndValues.keySet();
        Iterator namesIterator = names.iterator();
        while(namesIterator.hasNext()){
            String name = (String)namesIterator.next();
            addCheckBox(name, name,
                    ((Boolean)namesAndValues.get(name)).booleanValue());
        }    
    }

    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** Generate a change request to apply the changes.
     *  This is called to notify that one of the entries has changed.
     *  The name of the entry is passed as an argument.
     *  @param name The name of the entry.
     */
    public void changed(String name) {
        //System.out.println("Changed: " + name);
    }
    
    public void restore(){
        //System.out.println("restored");
    }

    ///////////////////////////////////////////////////////////////////
    ////                         private variables                 ////
}
