package ptolemy.actor;
//import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.util.DFUtilities;

import ptolemy.domains.sdf.kernel.SDFDirector;
import ptolemy.domains.sdf.kernel.SDFScheduler;



import ptolemy.data.expr.Parameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.Variable;

import ptolemy.kernel.Port;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;


import ptolemy.data.Token;
import ptolemy.data.IntToken; //for debugging

import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Attribute;
import ptolemy.moml.MoMLChangeRequest;

public class StreamActor extends TypedAtomicActor {

	public StreamActor(CompositeEntity container) 
		throws NameDuplicationException, IllegalActionException  {
		super(container, "StreamActor");
	}
	
	//not sure if we still need this method...
	public boolean empty() { return portTokenMap.isEmpty(); }

	public void initializeStreamActor() {
		portTokenMap = new HashMap();
	}

	//tokens key is an int channel and the value are the tokens being sent
	//on that channel.
	public void addConnection(TypedIOPort source, TypedIOPort sink, HashMap tokens) {
		

		//System.out.println("addConnection with:\n" + source +
			//			   "\n" + sink +
				//		   "\n" + tokens);

		//create a sending port for the StreamActor
		TypedIOPort streamPort = null;
		try {
			String name = "streamPort:"+source.getFullName();
			name = name.replace('.', '-');
			Entity container = this;//(Entity) getContainer();
			if ((container != null)) {

			//	System.out.println("here are the ports in the container: " + container.portList() + "\n   the container is: " + container);


				TypedIOPort another = (TypedIOPort) container.getPort(name);
				if (another != null)
					streamPort = another;
				else {
					streamPort = new TypedIOPort(this, name, false, true);
					streamPort.setTypeEquals(source.getType());
				//	System.out.println("created a new port: " + streamPort);
				}
			}
		} catch (Exception e) {
			System.err.println("\nSomething bad happened while creating a port()" +
							   "in StreamActor. \n Exception is: " + e);
		}
		//unlink the old sending ports and link in our ports.			
		List foundRelations = new ArrayList();
		Iterator relations = sink.linkedRelationList().iterator();
		while (relations.hasNext()) {
			IORelation relation = (IORelation)relations.next();
			if (relation != null) {
				//check to see if this relation goes to the source
				Iterator linkedPorts = relation.linkedPortList().iterator();
				while (linkedPorts.hasNext()) {
					Port otherPort = (Port) linkedPorts.next();
					if (otherPort.equals(source)) {
						//System.out.println(otherPort + " matches the source port" + source);
						
						//add this relation to the list of relations for this edge.
						foundRelations.add(relation);
						
						//now that we know this is a relation that connects the two
						//ports, we can unlink this relation and replace with our own.
					}
// 					else 
// 						System.out.println(otherPort + " does not match the source port: " + 
// 										   source);
				}
			}
		}

		//we now have a list of the relations that are a part of this edge!
		//now lets find which channels correspond to which relations.
		relations = new HashSet(foundRelations).iterator();
		while (relations.hasNext()) {
			try{
				IORelation relation = (IORelation) relations.next();
				
				//System.out.println("unlinking relation " + relation + 
				//				   "between ports: " + sink + " and " + source);
				sink.unlink(relation);
				//System.out.println("\n  The relations container is: " + 
				//				   relation.getContainer());

				TypedIORelation streamRelation = null;
				try {
					String name = "streamRelation:"+relation.getFullName();
					name = name.replace('.', '-');
					CompositeEntity container = (CompositeEntity) getContainer();
					if ((container != null)) {
						TypedIORelation another = (TypedIORelation)container.getRelation(name);
						if (another != null)
							streamRelation = another;
						else {
							streamRelation= 
								new TypedIORelation( (CompositeEntity)getContainer(), name );
							streamRelation.setWidth(relation.getWidth());
							streamPort.link(streamRelation);
						}
					}
				} catch (Exception e) {
					System.err.println("An error occured while creating relation with name: " + 
									   "StreamRelation-" + relation.toString());
					System.err.println("Error was: " + e);
				}
				sink.link(streamRelation);
			} catch (IllegalActionException e) {
				System.err.println("error occured while linking...");
				System.err.println("Error was: " + e);
			}
		}


		/*TODO: this doesn't handle firingsPerIteration, so if a sink actor changes
		 *its consumption rate, the source actor will most likely have its 
		 *firingsPerIteration changed and so the source actor will be rerun. It's
		 *possible this can be fixed...
		 */
		int sendRate = 1;
		try { sendRate = DFUtilities.getTokenProductionRate(source); }
		catch(IllegalActionException e) {
			System.err.println("Error trying to get TokenProductionRate: " + e);
		}

		int firingCount = 0;
		//System.out.println("actor Attributes are: " + source.getContainer().attributeList());
		//System.out.println("filters attribute list is: " + 
			//			   source.getContainer().attributeList(ptolemy.data.expr.Variable.class));
		for (Iterator attributes = source.getContainer().attributeList(Variable.class).iterator();
			 attributes.hasNext(); ) {
			Variable var = (Variable) attributes.next();
			if (var.toString().indexOf("firingsPerIteration") >=0 ) {
				try { 
					firingCount = ((IntToken)var.getToken()).intValue(); 
				} catch (Exception e) {
					System.err.println("Exception occured trying to get firings per iteration value." +
									   e);
				}
			}
		}

		if (firingCount == 0) {
			//TODO: make sure this hack always works...
			System.err.println("Potential Error: we got 0 for firingsPerIteration!" +
							   "Setting FPI to 1.");
			firingCount = 1;
		}

		Director director = getDirector();
		if (director instanceof SDFDirector) {
			SDFDirector sdf_director = (SDFDirector) director;
		//	System.out.println("The firing count for " + source + " is: " + firingCount);
			sendRate *= firingCount;
		}

		try { DFUtilities.setTokenProductionRate(streamPort, sendRate); }
		catch(IllegalActionException e) {
			System.err.println("Error trying to set TokenProductionRate: " + e);
		}

		//System.out.println("StreamPort Attributes are: " + streamPort.attributeList());

// 		//copy attributes
// 		//TODO: make sure there aren't attributes we should NOT copy.
// 		for (Iterator attributes = source.attributeList().iterator();
// 			 attributes.hasNext(); ) {
// 			try {
// 				Attribute attribute = (Attribute) attributes.next();
// 				if (attribute instanceof Variable)
// 					( (Variable)attribute ).validate();
// 				attribute.setContainer(streamPort);
// 			} catch (IllegalActionException e) {
// 				System.err.println("error swapping attributes: " + e);
// 			} catch (NameDuplicationException e) {
// 				System.err.println("error swapping attributes: " + e);
// 			}
// 		}
		
		//System.out.println("sendRate was : " + sendRate + " StreamPort Attributes are: " + streamPort.attributeList());

		//need to make a copy of the list of tokens
		HashMap tokens_copy = new HashMap();
		if (tokens != null)
			for (Iterator channelTokenEntries = tokens.entrySet().iterator();
				 channelTokenEntries.hasNext(); ) {
				Map.Entry channelTokenEntry = (Map.Entry) channelTokenEntries.next();
				tokens_copy.put(channelTokenEntry.getKey(), 
								((ArrayList)channelTokenEntry.getValue()).clone());
			}

		portTokenMap.put(streamPort, tokens_copy);
	}

	public void fire() throws IllegalActionException {
		//		System.out.println("entered fire()");
		super.fire();
		//System.out.println(this + "is fire()");

		boolean sentToken = false;
		for (Iterator portTokenMapEntries = portTokenMap.entrySet().iterator(); 
			 portTokenMapEntries.hasNext(); ) {
			Map.Entry portTokenMapEntry = (Map.Entry)portTokenMapEntries.next();
			TypedIOPort streamPort = (TypedIOPort) portTokenMapEntry.getKey();
			
			int sendRate = 1;
			try { sendRate = DFUtilities.getTokenProductionRate(streamPort); }
			catch(IllegalActionException e) {
				System.err.println("Error trying to get TokenProductionRate: " + e);
			}
			//System.out.println("in fire of first for loop. sendRate is: " + sendRate);
			for (int i = 0; i < sendRate; i++) {
				int channel = 0; //XXXX not at all sure this is right for channels!
				HashMap channelTokensMap = (HashMap)portTokenMapEntry.getValue();		
				if (channelTokensMap != null)
					for (Iterator tokenLists = channelTokensMap.values().iterator();
						 tokenLists.hasNext(); ) {
						List tokens = (List) tokenLists.next();
						
						// System.out.println("sending " + (i+1) + " of "+
// 										   sendRate + " tokens: " + tokens);

						if (tokens.isEmpty() == false) {
							Token token = (Token) tokens.get(0);
							// System.out.println("Sending token: " + token);
							streamPort.send(channel++, token);
							tokens.remove(0);
// 							sentToken = true;
						}
						else {
							System.err.println("fire called on StreamActor, port: " + streamPort +
											   "when there is nothing to fire.");
							System.err.println("We have " + channelTokensMap.values().size() +
											   " tokens");
							System.err.println("Here are the channelTokensMaps:" + channelTokensMap);
							//streamPort.send(channel++, new IntToken(-999)); 
						}
					}
			}
		}

		//TODO: optimize this. This is gross.
		//lets see if we have anything left:
		for (Iterator portTokenMapEntries = portTokenMap.entrySet().iterator(); 
			 portTokenMapEntries.hasNext(); ) {
			Map.Entry portTokenMapEntry = (Map.Entry)portTokenMapEntries.next();
			TypedIOPort streamPort = (TypedIOPort) portTokenMapEntry.getKey();
			HashMap channelTokensMap = (HashMap)portTokenMapEntry.getValue();
			if (channelTokensMap != null)
				for (Iterator tokenLists = channelTokensMap.values().iterator();
					 tokenLists.hasNext(); ) {
					List tokens = (List) tokenLists.next();
					if (tokens.isEmpty() == false)
						sentToken = true;
				}
		}

		//System.out.println("End iteration with sentToken="+sentToken);
		if (sentToken == false)
			stop();
	}

	/** The out ports of the StreamActor */
	protected HashMap portTokenMap;
}