/**
 *    '$RCSfile: SegmentFileReader.java,v $'
 *
 *     '$Author: ruland $'
 *       '$Date: 2005/11/01 20:39:16 $'
 *   '$Revision: 1.3 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package util;

import java.io.BufferedReader;

import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

/**
 * class to extend the FileReader to specify a segment of the file to read.
 * NOTE:
 * Originally written by Yang Zhao of the Ptolemy project.
 */
public class SegmentFileReader extends FileReader
{

  /**
   *@param  workspace
   *@exception  IllegalActionException
   *@exception  NameDuplicationException
   */
  public SegmentFileReader(Workspace workspace)
    throws IllegalActionException, NameDuplicationException
  {
    super(workspace);
    fromLine = new Parameter(this, "fromLine");
    fromLine.setExpression("0");
    fromLine.setTypeEquals(BaseType.INT);
    toLine = new Parameter(this, "toLine");
    toLine.setExpression("-1");
    toLine.setTypeEquals(BaseType.INT);


  }

  /**
   *@param  container                     The container.
   *@param  name                          The name of this actor.
   *@exception  IllegalActionException    If the container is incompatible
   *   with this actor.
   *@exception  NameDuplicationException  If the name coincides with
   *   an actor already in the container.
   */
  public SegmentFileReader(CompositeEntity container, String name)
    throws IllegalActionException, NameDuplicationException
  {
    super(container, name);
    fromLine = new Parameter(this, "fromLine");
    fromLine.setExpression("0");
    fromLine.setTypeEquals(BaseType.INT);
    toLine = new Parameter(this, "toLine");
    toLine.setExpression("-1");
    toLine.setTypeEquals(BaseType.INT);
  }
  /** begin reading from  fromLine */ 
  public Parameter fromLine;
  
  /** end reading before toLine */
  public Parameter toLine;
  /**
   * Output the data read from the port
   *
   *@exception  IllegalActionException  If there is no director.
   */
  public void fire()
    throws IllegalActionException
  {
    try
    {
      BufferedReader reader;
      filename.update();
      StringToken st = (StringToken)filename.getToken();
      String filenameStr = st.toString();
      if(filenameStr.indexOf("\"") != -1)
      { //trim the quotes
        filenameStr = filenameStr.substring(1, filenameStr.length() - 1);
      }
      reader = new BufferedReader(new java.io.FileReader(filenameStr));

      StringBuffer momlBuffer = new StringBuffer();
      String newline = System.getProperty("line.separator");
      
      int from = 0, to = -1;
      String fromStr = fromLine.getExpression();
      if (!fromStr.equals("")) { 
      	from = ((IntToken)fromLine.getToken()).intValue();
      }
      String toStr = toLine.getExpression();
      if (!toStr.equals("")) {
      	to = ((IntToken)toLine.getToken()).intValue();
      }
      String line = "";
      int lineCnt = 0;
      while(lineCnt < from)
      {
        line = reader.readLine();
        lineCnt++;
      }
      momlBuffer = momlBuffer.append(line);
      if (to == -1) {
     	while ((line = reader.readLine()) != null) {
            momlBuffer = momlBuffer.append(newline);
            momlBuffer = momlBuffer.append(line);
      	}
      } else {
      	while (lineCnt+1 < to) {
      		lineCnt++;
            line = reader.readLine();
            if (line == null) break;
            momlBuffer = momlBuffer.append(newline);
            momlBuffer = momlBuffer.append(line);      		
      	}
      }
      	
      String momlString = momlBuffer.toString();

      output.broadcast(new StringToken(momlString));
    }
    catch(Exception ex)
    {
      throw new IllegalActionException(this, ex.getMessage());
    }
  }

  /**
   *@return boolean
   *@exception  IllegalActionException  If the superclass throws it.
   */
  public boolean prefire()
    throws IllegalActionException
  {
    filename.update();
    if(filename.getToken() != null)
    {
      return true;
    }
    return false;
  }

}

