/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client;

import com.ibm.lsid.LSID;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;

public class LSIDAuthority {
    public static final String AUTHORITY_ID_PREFIX = "lsidauth:";
    private static final String AUTHORITY_PROTOCOL = "http";
    private static final String AUTHORITY_PATH = "/authority/";
    private String authority;
    private String server;
    private int port = -1;
    private String url;
    private LSIDWSDLWrapper authorityWSDL;

    public LSIDAuthority(String string) throws MalformedLSIDException {
        try {
            this.authority = string.toLowerCase();
            if (this.authority.startsWith(AUTHORITY_ID_PREFIX)) {
                this.authority = this.authority.substring(AUTHORITY_ID_PREFIX.length());
            }
        }
        catch (Exception exception) {
            throw new MalformedLSIDException(exception, "LSID Authority must be valid authority string, or of form: lsidauth:<validauthoritystring>");
        }
    }

    public LSIDAuthority(LSID lSID) throws MalformedLSIDException {
        this.authority = lSID.getAuthority().getAuthority();
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getAuthorityID() {
        return AUTHORITY_ID_PREFIX + this.authority;
    }

    public String toString() {
        return this.authority;
    }

    public int getPort() {
        return this.port;
    }

    public String getServer() {
        return this.server;
    }

    public String getUrl() {
        if (this.url == null) {
            if (this.server != null && this.port != -1) {
                this.url = "http://" + this.getServer() + ":" + this.getPort() + AUTHORITY_PATH;
            } else {
                return null;
            }
        }
        return this.url;
    }

    void setPort(int n) {
        this.port = n;
    }

    void setServer(String string) {
        this.server = string;
    }

    void setUrl(String string) {
        this.url = string;
    }

    void setWSDL(LSIDWSDLWrapper lSIDWSDLWrapper) {
        this.authorityWSDL = lSIDWSDLWrapper;
    }

    public LSIDWSDLWrapper getWSDL() {
        return this.authorityWSDL;
    }

    public boolean isResolved() {
        return this.getUrl() != null;
    }

    static String getAuthorityEnpointURL(String string, int n) {
        return "http://" + string + ":" + n + AUTHORITY_PATH;
    }
}

