/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.async;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.async.ResolutionListener;
import com.ibm.lsid.client.async.utils.WorkPool;
import com.ibm.lsid.client.metadata.LSIDMetadata;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import java.io.InputStream;

public class AsyncLSIDResolver {
    private static final int MAX_THREADS = 10;
    private WorkPool pool = new WorkPool(10);
    private ResolutionListener listener;
    private LSIDResolver resolver;
    private static int nextRequestID = 1;

    private static Integer getNextRequestID() {
        return new Integer(nextRequestID++);
    }

    public AsyncLSIDResolver(ResolutionListener resolutionListener) {
        this.listener = resolutionListener;
    }

    public AsyncLSIDResolver(ResolutionListener resolutionListener, LSID lSID) throws LSIDException {
        this.listener = resolutionListener;
        this.resolver = new LSIDResolver(lSID);
    }

    public AsyncLSIDResolver(ResolutionListener resolutionListener, LSIDAuthority lSIDAuthority, LSID lSID) throws LSIDException {
        this.listener = resolutionListener;
        this.resolver = new LSIDResolver(lSIDAuthority, lSID);
    }

    public AsyncLSIDResolver(ResolutionListener resolutionListener, LSID lSID, LSIDCredentials lSIDCredentials) throws LSIDException {
        this.listener = resolutionListener;
        this.resolver = new LSIDResolver(lSID, lSIDCredentials);
    }

    public AsyncLSIDResolver(ResolutionListener resolutionListener, LSIDAuthority lSIDAuthority, LSID lSID, LSIDCredentials lSIDCredentials) throws LSIDException {
        this.listener = resolutionListener;
        this.resolver = new LSIDResolver(lSIDAuthority, lSID, lSIDCredentials);
    }

    public AsyncLSIDResolver(ResolutionListener resolutionListener, LSIDResolver lSIDResolver) throws LSIDException {
        this.listener = resolutionListener;
        this.resolver = lSIDResolver;
    }

    public void destroy() {
        this.pool.destroy();
    }

    public LSIDResolver getLSIDResolver() {
        return this.resolver;
    }

    public Integer resolveAuthority(LSIDAuthority lSIDAuthority) {
        final LSIDAuthority lSIDAuthority2 = lSIDAuthority;
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        this.pool.addJob(new Runnable(){

            public void run() {
                block3: {
                    try {
                        if (lSIDAuthority2.isResolved()) {
                            AsyncLSIDResolver.this.listener.resolveAuthorityComplete(n, lSIDAuthority2);
                            break block3;
                        }
                        LSIDAuthority lSIDAuthority = LSIDResolver.resolveAuthority(lSIDAuthority2);
                        AsyncLSIDResolver.this.listener.resolveAuthorityComplete(n, lSIDAuthority);
                    }
                    catch (LSIDException lSIDException) {
                        AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                    }
                }
            }
        });
        return n;
    }

    public Integer getWSDLWrapper() {
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    LSIDWSDLWrapper lSIDWSDLWrapper = AsyncLSIDResolver.this.resolver.getWSDLWrapper();
                    AsyncLSIDResolver.this.listener.getWSDLWrapperComplete(n, lSIDWSDLWrapper);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                }
            }
        });
        return n;
    }

    public Integer getData() {
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    InputStream inputStream = AsyncLSIDResolver.this.resolver.getData();
                    AsyncLSIDResolver.this.listener.getDataComplete(n, inputStream);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                }
            }
        });
        return n;
    }

    public Integer getData(int n, int n2) {
        final Integer n3 = AsyncLSIDResolver.getNextRequestID();
        final int n4 = n;
        final int n5 = n2;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    InputStream inputStream = AsyncLSIDResolver.this.resolver.getData(n4, n5);
                    AsyncLSIDResolver.this.listener.getDataComplete(n3, inputStream);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n3, lSIDException);
                }
            }
        });
        return n3;
    }

    public Integer getData(LSIDDataPort lSIDDataPort) {
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        final LSIDDataPort lSIDDataPort2 = lSIDDataPort;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    InputStream inputStream = AsyncLSIDResolver.this.resolver.getData(lSIDDataPort2);
                    AsyncLSIDResolver.this.listener.getDataComplete(n, inputStream);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                }
            }
        });
        return n;
    }

    public Integer getData(LSIDDataPort lSIDDataPort, int n, int n2) {
        final Integer n3 = AsyncLSIDResolver.getNextRequestID();
        final int n4 = n;
        final int n5 = n2;
        final LSIDDataPort lSIDDataPort2 = lSIDDataPort;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    InputStream inputStream = AsyncLSIDResolver.this.resolver.getData(lSIDDataPort2, n4, n5);
                    AsyncLSIDResolver.this.listener.getDataComplete(n3, inputStream);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n3, lSIDException);
                }
            }
        });
        return n3;
    }

    public Integer getMetadata() throws LSIDException {
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    MetadataResponse metadataResponse = AsyncLSIDResolver.this.resolver.getMetadata();
                    AsyncLSIDResolver.this.listener.getMetadataComplete(n, metadataResponse);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                }
            }
        });
        return n;
    }

    public Integer getMetadata(String[] stringArray) throws LSIDException {
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        final String[] stringArray2 = stringArray;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    MetadataResponse metadataResponse = AsyncLSIDResolver.this.resolver.getMetadata(stringArray2);
                    AsyncLSIDResolver.this.listener.getMetadataComplete(n, metadataResponse);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                }
            }
        });
        return n;
    }

    public Integer getMetadata(LSIDMetadataPort lSIDMetadataPort) throws LSIDException {
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        final LSIDMetadataPort lSIDMetadataPort2 = lSIDMetadataPort;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    MetadataResponse metadataResponse = AsyncLSIDResolver.this.resolver.getMetadata(lSIDMetadataPort2);
                    AsyncLSIDResolver.this.listener.getMetadataComplete(n, metadataResponse);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                }
            }
        });
        return n;
    }

    public Integer getMetadata(LSIDMetadataPort lSIDMetadataPort, String[] stringArray) throws LSIDException {
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        final LSIDMetadataPort lSIDMetadataPort2 = lSIDMetadataPort;
        final String[] stringArray2 = stringArray;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    MetadataResponse metadataResponse = AsyncLSIDResolver.this.resolver.getMetadata(lSIDMetadataPort2, stringArray2);
                    AsyncLSIDResolver.this.listener.getMetadataComplete(n, metadataResponse);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                }
            }
        });
        return n;
    }

    public Integer getMetadataStore() throws LSIDException {
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    LSIDMetadata lSIDMetadata = AsyncLSIDResolver.this.resolver.getMetadataStore();
                    AsyncLSIDResolver.this.listener.getMetadataStoreComplete(n, lSIDMetadata);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                }
            }
        });
        return n;
    }

    public Integer getMetadataStore(String[] stringArray) throws LSIDException {
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        final String[] stringArray2 = stringArray;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    LSIDMetadata lSIDMetadata = AsyncLSIDResolver.this.resolver.getMetadataStore(stringArray2);
                    AsyncLSIDResolver.this.listener.getMetadataStoreComplete(n, lSIDMetadata);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                }
            }
        });
        return n;
    }

    public Integer getMetadataStore(LSIDMetadataPort lSIDMetadataPort) throws LSIDException {
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        final LSIDMetadataPort lSIDMetadataPort2 = lSIDMetadataPort;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    LSIDMetadata lSIDMetadata = AsyncLSIDResolver.this.resolver.getMetadataStore(lSIDMetadataPort2);
                    AsyncLSIDResolver.this.listener.getMetadataStoreComplete(n, lSIDMetadata);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                }
            }
        });
        return n;
    }

    public Integer getMetadataStore(LSIDMetadataPort lSIDMetadataPort, String[] stringArray) throws LSIDException {
        final Integer n = AsyncLSIDResolver.getNextRequestID();
        final LSIDMetadataPort lSIDMetadataPort2 = lSIDMetadataPort;
        final String[] stringArray2 = stringArray;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    LSIDMetadata lSIDMetadata = AsyncLSIDResolver.this.resolver.getMetadataStore(lSIDMetadataPort2, stringArray2);
                    AsyncLSIDResolver.this.listener.getMetadataStoreComplete(n, lSIDMetadata);
                }
                catch (LSIDException lSIDException) {
                    AsyncLSIDResolver.this.listener.requestFailed(n, lSIDException);
                }
            }
        });
        return n;
    }
}

